#include "view_config.h"
#include  <cassert>

using namespace std;


const double	View_Config::DEFAULT_PLAYER_SIZE = 1.3;
const double	View_Config::DEFAULT_BALL_SIZE   = 0.8;
const double	View_Config::DEFAULT_MAGNIFY     = 8.0;

View_Config::View_Point::View_Point()
	: type( View_Point::Point ) ,
	  coordinate( 0.0 , 0.0 ) ,
	  player()
{
}

View_Config::Debug_View_Config::Debug_View_Config()
	: debug_ball( false ) ,
	  debug_self( false ) ,
	  debug_players( false ) ,
	  debug_comment( false )
{
}


View_Config::View_Config( bool  auto_drop ,
			  bool  auto_kick_off ,
			  bool  auto_quit ,
			  bool  player_view_angle )
	: monitor_view( true ) , player_view_angle( player_view_angle ) ,
	  offside_line( false ) ,
	  view_point() ,
	  auto_adjust_magnify( true ) , field_magnify( DEFAULT_MAGNIFY ) ,
	  inverse_x( false ) , inverse_y( false ) ,
	  player_size( DEFAULT_PLAYER_SIZE ) , ball_size( DEFAULT_BALL_SIZE ) ,
	  draw_grid( false ) , grid_width( 5.0 ) ,
	  draw_circle( false ) , circle_radius( 3.0 ) ,
	  use_teamname( true ) ,
	  auto_drop( auto_drop ) ,
	  auto_kick_off( auto_kick_off ) ,
	  auto_quit( auto_quit )
{
}

View_Config::~View_Config()
{
}

View_Config::Debug_View_Config &  View_Config::debug_config
						( const S_Side_LR &  side ,
						  int  player_number )
{
	assert( side != S_Side_LR::Unknown
		&& (1 <= player_number && player_number <= MAX_PLAYER) );

	if ( side == S_Side_LR::Right_Side )
	{
		return( right_player[ player_number - 1 ] );
	}
	else
	{
		return( left_player[ player_number - 1 ] );
	}
}

const View_Config::Debug_View_Config &  View_Config::debug_config
						    ( const S_Side_LR &  side ,
						      int  player_number )
	const
{
	return( const_cast<View_Config *>(this)
		  -> debug_config( side , player_number ) );
}
