#ifndef	   VIEW_CONFIG_H_INCLUDED
#define	   VIEW_CONFIG_H_INCLUDED

// Author:		H. Shimora
// Created:		May 24 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  May 24 2000    base version.
//
//

#include  "d2_vector.h"
#include  "s_basic.h"

struct  View_Config
{
public:
	struct  Debug_View_Config
	{
		bool	debug_ball;
		bool	debug_self;
		bool	debug_players;
		bool	debug_comment;

	public:
		Debug_View_Config();
	};

public:
	struct View_Point
	{
	public:
		enum Type { Point , Ball , Player };

	public:
		View_Point::Type		type;
		D2_Vector			coordinate;
		SObject_Player_Identifier	player;

	public:
		View_Point();
	};

public:
	static	const double	DEFAULT_PLAYER_SIZE;
	static	const double	DEFAULT_BALL_SIZE;

	static	const double	DEFAULT_MAGNIFY;

public:
	 View_Config( bool  auto_drop ,
		      bool  auto_kick_off ,
		      bool  auto_quit ,
		      bool  player_view_angle );
	~View_Config();

	//
	// What to Display
	//
	bool	monitor_view;
	bool	player_view_angle;
	bool	offside_line;

	Debug_View_Config	left_player [MAX_PLAYER];
	Debug_View_Config	right_player[MAX_PLAYER];

	Debug_View_Config &		debug_config( const S_Side_LR &  side ,
						      int  player_number );

	const Debug_View_Config &	debug_config( const S_Side_LR &  side ,
						      int  player_number )
									const;


	//
	// How to Display
	//
	View_Point	view_point;

	bool		auto_adjust_magnify;
	double		field_magnify;

	bool		inverse_x;
	bool		inverse_y;

	double		player_size;
	double		ball_size;

	bool		draw_grid;
	double		grid_width;

	bool		draw_circle;
	double		circle_radius;

	bool		use_teamname;


	//
	// Connection Operation
	//
	bool		auto_drop;
	bool		auto_kick_off;
	bool		auto_quit;
};


#endif	/* VIEW_CONFIG_H_INCLUDED */
