#include  "view_controll_panel.h"
#include  <string>

using namespace std;

//
// View_Controll_Panel
//
const	gint	View_Controll_Panel::DEFAULT_WIDTH  = 930;  // pixel
const	gint	View_Controll_Panel::DEFAULT_HEIGHT =  30;  // pixel

View_Controll_Panel::View_Controll_Panel( Time_Controller &  c ,
					  View_Config &  config ,
					  Soccer_Viewer &  viewer )
	: Gtk::Table( 1 , 15 , true ) ,
	  controller( c ) ,
	  kick_off_button( "Kick Off" ) ,
	  config_button( "Config" ) ,
	  config_window( config , viewer , c , config_button ) ,
	  step_controller( c ) ,
	  mode_indicator( c ) ,
	  kill_server_button( "Kill Server" ) ,
	  quit_button( "Quit" )
{
	//
	// size
	//
	this -> set_usize( this -> DEFAULT_WIDTH , this -> DEFAULT_HEIGHT );


	//
	// Kick Off Button
	//
	kick_off_button.clicked.connect
		    ( SigC::slot( this , &View_Controll_Panel::send_start ) );
	kick_off_button.show();

	this -> attach( kick_off_button , 0 , 1 , 0 , 1 );


	//
	// Config Button & Window
	//
	config_button.toggled.connect(
		SigC::slot( this ,
			    &View_Controll_Panel::config_button_toggled ) );

	config_button.show();
	this -> attach( config_button , 1 , 2 , 0 , 1 );



	//
	// Step Controller
	//
	step_controller.show();
	this -> attach( step_controller , 2 , 11 , 0 , 1 );


	//
	// Log-Live Mode Indicator
	//
	mode_indicator.show();
	this -> attach( mode_indicator , 11 , 13 , 0 , 1 );


	//
	// Kill Server Button
	//
	kill_server_button.set_sensitive
				( controller.have_server_process_id() );

	if ( controller.have_server_process_id() )
	{
		kill_server_button.clicked.connect
		    ( SigC::slot( this , &View_Controll_Panel::kill_server ) );
	}
	kill_server_button.show();
	this -> attach( kill_server_button , 13 , 14 , 0 , 1 );


	//
	// Quit Button
	//
	quit_button.show();
	this -> attach( quit_button , 14 , 15 , 0 , 1 );
}

View_Controll_Panel::~View_Controll_Panel()
{
}

void   View_Controll_Panel::display()
{
	step_controller.display();
	mode_indicator .display();
}

void   View_Controll_Panel::send_start()
{
	controller.send_start();
}

void   View_Controll_Panel::kill_server()
{
	controller.kill_server();
	kill_server_button.set_sensitive( false );
}

void   View_Controll_Panel::config_button_toggled()
{
	if ( config_button.get_active() )
	{
		config_window.show();
	}
	else
	{
		config_window.hide();
	}
}

void   View_Controll_Panel::config_changed()
{
	config_window.config_changed();
}



//
// Log_Live_Mode_Indicator
//
Log_Live_Mode_Indicator::Log_Live_Mode_Indicator( const Time_Controller &  tc )
	: time_controller( tc ) , initialized( false ) ,
	  live_mode_cache( false ) , monitor_connected_cache( false )
{
}

Log_Live_Mode_Indicator::~Log_Live_Mode_Indicator()
{
}

void   Log_Live_Mode_Indicator::initialize()
{
	//
	// new pixmap
	//
	live_mode_pixmap  .create( get_window(), width() , height() );
	unconnected_pixmap.create( get_window(), width() , height() );
	log_mode_pixmap   .create( get_window(), width() , height() );


	//
	// GC
	//
	bg_gc                 .create( get_window() , "white" );
	live_mode_gc          .create( get_window() , "white" );
	live_mode_string_gc   .create( get_window() , "slateblue3" );
	unconnected_gc        .create( get_window() , "gray85" );
	unconnected_string_gc .create( get_window() , "white" );
	log_mode_gc           .create( get_window() , "slateblue3" );
	log_mode_string_gc    .create( get_window() , "gray85" );


	//
	// Font
	//
	font.set_load
		( "-adobe-helvetica-*-r-normal--24-240-75-75-p-*-iso8859-1" );


	//
	// draw pixmaps
	//
	draw_live_mode_image( live_mode_pixmap , font ,
			      live_mode_gc , live_mode_string_gc );

	draw_log_mode_image( log_mode_pixmap , font ,
			     log_mode_gc , log_mode_string_gc );

	draw_unconnected_image( unconnected_pixmap , font ,
				unconnected_gc , unconnected_string_gc );

	live_mode_cache = time_controller.live_mode();

	initialized = true;
}


gint   Log_Live_Mode_Indicator::configure_event_impl( GdkEventConfigure * )
{
	this -> initialize();

	return( true );
}

gint   Log_Live_Mode_Indicator::expose_event_impl( GdkEventExpose *  event )
{
	this -> draw_pixmap_to_window( event -> area.x ,
				       event -> area.y ,
				       event -> area.width ,
				       event-> area.height );

	return( false );
}

void   Log_Live_Mode_Indicator::draw_pixmap_to_window( gint  x ,  gint  y ,
						       gint  w ,  gint  h )
{
	if ( ! initialized )
	{
		this -> initialize();
	}


	Gdk_Pixmap *		pix;
	Gdk_GC_Wrapper *	g;

	if ( time_controller.live_mode() )
	{
		if ( time_controller.monitor_connection_responsive() )
		{
			pix = &live_mode_pixmap;
			g   = &live_mode_gc;
			this -> monitor_connected_cache = true;
		}
		else
		{
			pix = &unconnected_pixmap;
			g   = &unconnected_gc;
			this -> monitor_connected_cache = false;
		}

		this -> live_mode_cache = true;
	}
	else
	{
		pix = &log_mode_pixmap;
		g   = &log_mode_gc;
		this -> live_mode_cache = false;
	}

	get_window().draw_pixmap( *g ,
				  *pix ,
				  x , y ,
				  x , y ,
				  w , h );
}

void   Log_Live_Mode_Indicator::display()
{
	if ( ! initialized )
	{
		return;
	}

	if ( this -> live_mode_cache != time_controller.live_mode()
	  || (time_controller.live_mode()
	      && time_controller.monitor_connection_responsive()
		   != this -> monitor_connected_cache) )
	{
		this -> draw_pixmap_to_window( 0 ,
					       0 ,
					       this -> width() ,
					       this -> height() );
	}
}


void   Log_Live_Mode_Indicator::draw_live_mode_image
	( Gdk_Pixmap &  pix , Gdk_Font &  font ,
	  Gdk_GC_Wrapper &  gc ,  Gdk_GC_Wrapper &  string_gc )
{
	//
	// fill background
	//
	pix.draw_rectangle( gc , true , 0 , 0 , pix.width() , pix.height() );


	//
	// draw string
	//
	string	mode_string = "Live !!";

	gint	lbearing;
	gint	rbearing;
	gint	text_width;
	gint	ascent;
	gint	descent;

	font.string_extents( mode_string ,
			     lbearing , rbearing ,
			     text_width ,
			     ascent , descent );

	if ( (lbearing + rbearing) > pix.width() )
	{
		mode_string = "Live";
		font.string_extents( mode_string ,
				     lbearing , rbearing ,
				     text_width ,
				     ascent , descent );
	}


	pix.draw_string( font ,
			 string_gc ,
			 (pix.width() - (lbearing + rbearing)) / 2 ,
			 (pix.height() - (descent - ascent)) / 2 ,
			 mode_string );
}

void   Log_Live_Mode_Indicator::draw_log_mode_image
	( Gdk_Pixmap &  pix , Gdk_Font &  font ,
	  Gdk_GC_Wrapper &  gc ,  Gdk_GC_Wrapper &  string_gc )
{
	//
	// fill background
	//
	pix.draw_rectangle( gc , true , 0 , 0 , pix.width() , pix.height() );


	//
	// draw string
	//
	const	string	mode_string = "Log";

	gint	lbearing;
	gint	rbearing;
	gint	text_width;
	gint	ascent;
	gint	descent;

	font.string_extents( mode_string ,
			     lbearing , rbearing ,
			     text_width ,
			     ascent , descent );

	pix.draw_string( font ,
			 string_gc ,
			 (pix.width() - (lbearing + rbearing)) / 2 ,
			 (pix.height() - (descent - ascent)) / 2 ,
			 mode_string );
}

void   Log_Live_Mode_Indicator::draw_unconnected_image
	( Gdk_Pixmap &  pix , Gdk_Font &  font ,
	  Gdk_GC_Wrapper &  gc ,  Gdk_GC_Wrapper &  string_gc )
{
	//
	// fill background
	//
	pix.draw_rectangle( gc , true , 0 , 0 , pix.width() , pix.height() );


	//
	// draw string
	//
	string	mode_string = "Live";

	gint	lbearing;
	gint	rbearing;
	gint	text_width;
	gint	ascent;
	gint	descent;

	font.string_extents( mode_string ,
			     lbearing , rbearing ,
			     text_width ,
			     ascent , descent );

	pix.draw_string( font ,
			 string_gc ,
			 (pix.width() - (lbearing + rbearing)) / 2 ,
			 (pix.height() - (descent - ascent)) / 2 ,
			 mode_string );
}
