#ifndef	   VIEW_CONTROLL_PANEL_H_INCLUDED
#define	   VIEW_CONTROLL_PANEL_H_INCLUDED

// Author:		H. Shimora
// Created:		Jun  7 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Jun  7 2000    base version.
//
//

#include  <gtk--.h>
#include  "time_controller.h"
#include  "step_controller.h"
#include  "config_window.h"
#include  "quit_button.h"
#include  "gdk_gc_wrapper.h"

class  Log_Live_Mode_Indicator : public Gtk::DrawingArea
{
protected:
	const Time_Controller &	time_controller;

	bool			initialized;

	bool			live_mode_cache;
	bool			monitor_connected_cache;

	Gdk_Pixmap		live_mode_pixmap;
	Gdk_Pixmap		log_mode_pixmap;
	Gdk_Pixmap		unconnected_pixmap;

	Gdk_GC_Wrapper		live_mode_gc;
	Gdk_GC_Wrapper		unconnected_gc;
	Gdk_GC_Wrapper		log_mode_gc;
	Gdk_GC_Wrapper		bg_gc;
	Gdk_GC_Wrapper		live_mode_string_gc;
	Gdk_GC_Wrapper		unconnected_string_gc;
	Gdk_GC_Wrapper		log_mode_string_gc;
	Gdk_Font		font;

	void	draw_pixmap_to_window( gint  x ,  gint  y ,
				       gint  w ,  gint  h );

	static	void	draw_log_mode_image( Gdk_Pixmap &  pix ,
					     Gdk_Font &  font ,
					     Gdk_GC_Wrapper  &  gc ,
					     Gdk_GC_Wrapper &  string_gc );

	static	void	draw_live_mode_image( Gdk_Pixmap &  pix ,
					      Gdk_Font &  font ,
					      Gdk_GC_Wrapper &  gc ,
					      Gdk_GC_Wrapper &  string_gc );

	static	void	draw_unconnected_image( Gdk_Pixmap &  pix ,
						Gdk_Font &  font ,
						Gdk_GC_Wrapper &  gc ,
						Gdk_GC_Wrapper &  string_gc );

public:
		 Log_Live_Mode_Indicator( const Time_Controller & );
	virtual	~Log_Live_Mode_Indicator();

	virtual	void	initialize();
	virtual	gint	configure_event_impl( GdkEventConfigure * );
	virtual	gint	expose_event_impl( GdkEventExpose * );

	virtual	void	display();
};



class  View_Controll_Panel : public Gtk::Table
{
public:
	static	const	gint	DEFAULT_WIDTH;
	static	const	gint	DEFAULT_HEIGHT;

protected:
	Time_Controller &	controller;

	Gtk::Button		kick_off_button;

	Gtk::ToggleButton	config_button;
	Config_Window		config_window;

	Step_Controller		step_controller;

	Log_Live_Mode_Indicator	mode_indicator;

	Gtk::Button		kill_server_button;

	Quit_Button		quit_button;

protected:
	void	config_button_toggled();

public:
		 View_Controll_Panel( Time_Controller & , View_Config & ,
				      Soccer_Viewer & );
	virtual	~View_Controll_Panel();

	virtual	void	display();

	virtual	void	send_start();

	virtual	void	kill_server();

	virtual	void	config_changed();
};


#endif	/* VIEW_CONTROLL_PANEL_H_INCLUDED */
