#include  "viewer_field_canvas.h"
#include  <cstdlib>

Viewer_Field_Canvas::Viewer_Field_Canvas
			( Field_Canvas::Canvas_Event_Handler &  handler ,
			  Viewer_Field_Canvas::Monitor_Connection &  monitor ,
			  View_Config &  config ,
			  const SServer_Param &  param ,
			  gdouble  view_point_x = 0.0 ,
			  gdouble  view_point_y = 0.0 ,
			  gdouble  mag = DEFAULT_MAGNIFY ,
			  bool  inv_x = false ,
			  bool  inv_y = false )
	: Field_Canvas( handler , param ,
			view_point_x , view_point_y , mag , inv_x , inv_y ) ,
	  monitor( monitor ) ,
	  drop_menu_window( GTK_WINDOW_POPUP ) ,
	  drop_menu_vbox( true ) ,
	  drop_ball_button( "Drop Ball" ) ,
	  free_kick_left_button ( "Free Kick Left" ) ,
	  free_kick_right_button( "Free Kick Right" )
{
	//
	// drop window
	//
	drop_menu_vbox.pack_start( free_kick_left_button );
	drop_menu_vbox.pack_start( drop_ball_button );
	drop_menu_vbox.pack_start( free_kick_right_button );

	drop_ball_button      .show();
	free_kick_left_button .show();
	free_kick_right_button.show();

	drop_ball_button      .set_usize( 200 , 50 );
	free_kick_left_button .set_usize( 200 , 50 );
	free_kick_right_button.set_usize( 200 , 50 );

	drop_ball_button.released.connect
		( SigC::slot( this , &Viewer_Field_Canvas::drop_ball ) );

	free_kick_left_button.released.connect
		( SigC::slot( this , &Viewer_Field_Canvas::free_kick_left ) );

	free_kick_right_button.released.connect
		( SigC::slot( this , &Viewer_Field_Canvas::free_kick_right ) );

	drop_menu_window.add( drop_menu_vbox );

	drop_menu_vbox.show();
}


Viewer_Field_Canvas::~Viewer_Field_Canvas()
{
}


//
// drop_ball button callback
//
void   Viewer_Field_Canvas::drop_ball()
{
	drop_menu_window.hide();

	monitor.send_foul( drop_point.x() , drop_point.y() ,
			   S_Side_LR::Unknown );
}

//
// free_kick_left_button callback
//
void   Viewer_Field_Canvas::free_kick_left()
{
	drop_menu_window.hide();

	monitor.send_foul( drop_point.x() , drop_point.y() ,
			   S_Side_LR::Left_Side );
}

//
// free_kick_right_button callback
//
void   Viewer_Field_Canvas::free_kick_right()
{
	drop_menu_window.hide();

	monitor.send_foul( drop_point.x() , drop_point.y() ,
			   S_Side_LR::Right_Side );
}

gint   Viewer_Field_Canvas::button_press_event_impl( GdkEventButton *  event )
{
	if ( event -> button == 1 )
	{
		drop_point.set( pixmap.x_pixel_to_coordinate
				  ( static_cast<gint>( event -> x ) ) ,
				pixmap.y_pixel_to_coordinate
				  ( static_cast<gint>( event -> y ) ) );

		if ( std::fabs( drop_point.y() ) < FIELD_HALF_WIDTH  * 1.05 )
		{
			drop_menu_window.set_position( GTK_WIN_POS_MOUSE );
			drop_menu_window.show();
		}
	}

	return( false );
}

gint   Viewer_Field_Canvas::button_release_event_impl
						( GdkEventButton *  event )
{
	if ( event -> button == 1 )
	{
		drop_menu_window.hide();
	}

	return( false );
}
