#ifndef	   FIELD_CANVAS_H_INCLUDED
#define	   FIELD_CANVAS_H_INCLUDED

#include  <gtk--.h>
#include  <string>
#include  "sserver_param.h"
#include  "soccer_object_reference.h"
#include  "monitor_view_data.h"
#include  "team_config.h"
#include  "coordinate_view_pixmap.h"
#include  "transparent_pixmap.h"
#include  "gdk_gc_wrapper.h"

class  Field_Canvas : public Gtk::DrawingArea
{
public:
	class  Canvas_Event_Handler
	{
	public:
			 Canvas_Event_Handler();
		virtual	~Canvas_Event_Handler();
		virtual	void	configured() = 0;
		virtual	gint	button_pressed( GdkEventButton * ,
						double  x , double  y );
		virtual	gint	button_released( GdkEventButton * ,
						 double  x , double  y );
		virtual gint	key_pressed( GdkEventKey * );
		virtual gint	key_released( GdkEventKey * );
	};

public:
	static	const	gint	DEFAULT_WIDTH;
	static	const	gint	DEFAULT_HEIGHT;
	static	const	gdouble	DEFAULT_MAGNIFY;

protected:
	static	const	gint	MAX_AUTO_DROP_COLUMN;
	static	const	int	MAX_AUTO_KICK_OFF_COLUMN;
	static	const	int	MAX_AUTO_QUIT_COLUMN;

	static	const	gdouble	FIELD_HALF_WIDTH;
	static	const	gdouble	FIELD_HALF_LENGTH;
	static	const	gdouble	FIELD_WIDTH;
	static	const	gdouble	FIELD_LENGTH;
	static	const	gdouble	PENALTY_AREA_LENGTH;
	static	const	gdouble	PENALTY_AREA_HALF_WIDTH;
	static	const	gdouble	GOAL_AREA_LENGTH;
	static	const	gdouble	GOAL_AREA_HALF_WIDTH;
	static	const	gdouble	CENTER_CIRCLE_R;
	static	const	gdouble	CORNER_CIRCLE_R;
	static	const	gdouble	PENALTY_SPOT_DIST;

protected:
	const	gdouble		PENALTY_ARC_DIGREE;


protected:
	const SServer_Param &			param;
	Field_Canvas::Canvas_Event_Handler &	event_handler;

	gdouble					ratio;
	gdouble					center_x;
	gdouble					center_y;
	bool					inverse_x;
	bool					inverse_y;

protected:
	Coordinate_View_Pixmap<Gdk_Pixmap>	field_environment_pixmap;
	Coordinate_View_Pixmap<Transparent_Pixmap>	pixmap;

	Gdk_GC_Wrapper			window_gc;
	Gdk_GC_Wrapper			frame_gc;

	Gdk_GC_Wrapper			ground_gc;
	Gdk_GC_Wrapper			field_gc;
	Gdk_GC_Wrapper			line_gc;
	Gdk_GC_Wrapper			goal_gc;
	Gdk_GC_Wrapper			grid_main_gc;
	Gdk_GC_Wrapper			grid_sub_gc;
	Gdk_GC_Wrapper			player_circle_gc;
	Gdk_GC_Wrapper			ball_circle_gc;

	Gdk_GC_Wrapper			ball_gc;
	Gdk_GC_Wrapper			debug_ball_gc;
	Gdk_GC_Wrapper			ball_velocity_gc;
	Gdk_GC_Wrapper			ball_edge_gc;
	Gdk_GC_Wrapper			ball_comment_gc;

	Gdk_GC_Wrapper			left_field_player_gc;
	Gdk_GC_Wrapper			left_goalie_gc;
	Gdk_GC_Wrapper			right_field_player_gc;
	Gdk_GC_Wrapper			right_goalie_gc;
	Gdk_GC_Wrapper			realized_self_player_gc;
	Gdk_GC_Wrapper			realized_left_player_gc;
	Gdk_GC_Wrapper			realized_right_player_gc;
	Gdk_GC_Wrapper			unknown_player_gc;
	Gdk_GC_Wrapper			player_bg_gc;
	Gdk_GC_Wrapper			player_view_angle_gc;
	Gdk_GC_Wrapper			player_face_bar_gc;
	Gdk_GC_Wrapper			effort_reduced_gc;
	Gdk_GC_Wrapper			left_player_uniform_number_gc;
	Gdk_GC_Wrapper			right_player_uniform_number_gc;
	Gdk_GC_Wrapper			unknown_player_uniform_number_gc;
	Gdk_GC_Wrapper			player_name_gc;
	Gdk_GC_Wrapper			catch_fault_gc;

	Gdk_GC_Wrapper			target_point_gc;

	Gdk_Font			player_identification_font;
	Gdk_Font			comment_font;

	Gdk_GC_Wrapper			popup_string_gc;
	Gdk_Font			popup_font;

	gint				max_number_char_width;
	gint				auto_drop_message_x;
	gint				auto_drop_message_y;
	gint				auto_drop_message_width;
	gint				auto_kick_off_message_x;
	gint				auto_kick_off_message_y;
	gint				auto_kick_off_message_width;
	gint				auto_quit_message_x;
	gint				auto_quit_message_y;
	gint				auto_quit_message_width;

	bool				gc_font_initialized;

protected:
	virtual	void	gc_font_initialize_hook();

protected:
	virtual	void	gc_font_initialize();

	virtual	void	draw_field_environment_to_pixmap(
			  Coordinate_View_Pixmap<Gdk_Pixmap> &  pix );

	virtual	void	draw_grid_to_pixmap(
			  Coordinate_View_Pixmap<Transparent_Pixmap> &  pix ,
			  gdouble  grid_width );

	virtual	void	draw_circle_to_pixmap(
			  Coordinate_View_Pixmap<Transparent_Pixmap> &  pix ,
			  const Monitor_View_Data &  monitor_view_data ,
			  gdouble  circle_radius );

	virtual	void	draw_monitor_ball_to_pixmap(
			  Coordinate_View_Pixmap<Transparent_Pixmap> &  pix ,
			  const gdouble  ball_size ,
			  const D2_Vector &  ball ,
			  const Monitor_View_Data::Monitor_Play_Mode &  mode );

	virtual	void	draw_ball_to_pixmap(
			  Coordinate_View_Pixmap<Transparent_Pixmap> &  pix ,
			  const gdouble  ball_size ,
			  const D2_Vector &  ball ,
			  bool  draw_velocity ,
			  const D2_Vector &  velocity ,
			  S_Side_LR  side ,
			  const char *  comment = 0 ,
			  bool  for_debug = false );

	virtual	void	draw_player_to_pixmap(
			  Coordinate_View_Pixmap<Transparent_Pixmap> &  pix ,
			  const Monitor_View_Data::Player_State &  player ,
			  bool  draw_view_angle ,
			  gdouble  player_size ,
			  const char *  comment ,
			  const char *  player_name ,
			  bool  draw_player_name ,
			  const char *  player_color ,
			  bool  use_player_color ,
			  bool  self_player ,
			  const char *  debug_message ,
			  bool  for_debug );

	virtual	void	draw_popup_to_pixmap(
			  Coordinate_View_Pixmap<Transparent_Pixmap> &  pix ,
			  bool  use_teamname ,
			  const Monitor_View_Data::Monitor_Play_Mode &  mode ,
			  const std::string &  left_teamname ,
			  const std::string &  right_teamname );

	virtual	void	draw_auto_drop_count_down_to_pixmap(
			  Coordinate_View_Pixmap<Transparent_Pixmap> &  pix ,
			  glong  auto_drop_rest_count );

	virtual	void	draw_auto_kick_off_count_down_to_pixmap(
			  Coordinate_View_Pixmap<Transparent_Pixmap> &  pix ,
			  glong  auto_kick_off_rest_count );

	virtual	void	draw_auto_quit_count_down_to_pixmap(
			  Coordinate_View_Pixmap<Transparent_Pixmap> &  pix ,
			  glong  auto_quit_rest_count );

public:
		 Field_Canvas( Field_Canvas::Canvas_Event_Handler &  handler ,
			       const SServer_Param &  param ,
			       gdouble  view_point_x = 0.0 ,
			       gdouble  view_point_y = 0.0 ,
			       gdouble  mag = DEFAULT_MAGNIFY ,
			       bool  inv_x = false ,
			       bool  inv_y = false );

	virtual	~Field_Canvas();

	virtual	void	view_change( gdouble  view_point_x = 0.0 ,
				     gdouble  view_point_y = 0.0 ,
				     gdouble  mag = DEFAULT_MAGNIFY ,
				     bool  inv_x = false ,
				     bool  inv_y = false );

	virtual	gint	configure();

	virtual	gint	configure_event_impl( GdkEventConfigure * );
	virtual	gint	expose_event_impl( GdkEventExpose * );

	virtual	gint	button_press_event_impl( GdkEventButton * );
	virtual	gint	button_release_event_impl( GdkEventButton * );
	virtual gint	key_press_event_impl( GdkEventKey * );
	virtual gint	key_release_event_impl( GdkEventKey * );

	virtual	void	get_pointer_coordinate( double *  x ,  double *  y );

	virtual	void	clear_field();

	virtual	void	draw_grid( gdouble  grid_width );

	virtual	void	draw_circle
			    ( const Monitor_View_Data &  monitor_view_data ,
			      gdouble  circle_radius );

	virtual	void	draw_message_center( const std::string &  message );

	virtual	void	draw_monitor_view_data
			    ( const Monitor_View_Data &  monitor_view_data ,
			      bool  draw_view_angle ,
			      const Team_Config  team_config[2] ,
			      gdouble  player_size ,
			      gdouble  ball_size ,
			      bool  use_teamname );

	virtual	void	draw_auto_drop_count_down
			    ( glong  auto_drop_rest_count );

	virtual	void	draw_auto_kick_off_count_down
			    ( glong  auto_kick_off_rest_count );

	virtual	void	draw_auto_quit_count_down
			    ( glong  auto_quit_rest_count );

	virtual	void	draw_offside_line( gdouble  deffence_line ,
					   gdouble  offence_line ,
					   S_Side_LR  side );

	virtual	void	draw_offside_line
			    ( const Monitor_View_Data &  monitor_view_data );

	virtual	void	draw_ball( const Ball_Reference &  ball ,
				   S_Side_LR  self_side ,
				   gdouble  ball_size ,
				   const Play_Mode_Reference &  mode ,
				   bool  draw_velocity ,
				   const char *  comment ,
				   bool  for_debug );

	virtual	void	draw_player( const Player_Reference &  player ,
				     S_Side_LR  self_side ,
				     const Soccer_Composite_Command &  com ,
				     gdouble  player_size ,
				     const char *  comment ,
				     bool  draw_face_angle ,
				     bool  use_stamina ,
				     const char *  debug_message ,
				     bool  for_debug );

	virtual	void	draw_target_point( const D2_Vector &  point ,
					   S_Side_LR  self_side );

	virtual	void	update_field();
};


#endif	/* FIELD_CANVAS_H_INCLUDED */
