#include  "game_info_mode_line.h"
#include  "monitor_view_data.h"
#include  <vector>
#include  <string>
#include  <strstream>
#include  <algorithm>

using namespace std;

const	gint	Game_Info_Mode_Line::DEFAULT_WIDTH  = 930;  // pixel
const	gint	Game_Info_Mode_Line::DEFAULT_HEIGHT =  40;  // pixel

const	gdouble	Game_Info_Mode_Line::SIDE_RATIO = 0.25;

Game_Info_Mode_Line::Game_Info_Mode_Line
			( const Game_Info_Mode_Line::Model &  m )
	: model( m ) ,
	  initialized( false ) ,
	  play_mode_draw_offset( 0 ) , time_draw_offset( 0 ) ,
	  max_number_char_width( 0 ) , too_nallow( false ) ,
	  have_cache( false ) ,
	  left_teamname_cache( "" ) , right_teamname_cache( "" ) ,
	  left_score_cache( -1 ) , right_score_cache( -1 ) ,
	  play_mode_cache( "" ) , inverse_x_cache( false ) ,
	  drawn_rectangle_min_x( 0 ) , drawn_rectangle_min_y( 0 ) ,
	  drawn_rectangle_width( 0 ) , drawn_rectangle_height( 0 )
{
	this -> size( this -> DEFAULT_WIDTH , this -> DEFAULT_HEIGHT );
}

Game_Info_Mode_Line::~Game_Info_Mode_Line()
{
}


gint   Game_Info_Mode_Line::configure_event_impl( GdkEventConfigure * )
{
	//
	// new pixmap
	//
	background_pixmap.create( get_window(), width() , height() );
	time_pixmap      .create( get_window(), width() , height() );


	//
	// GC
	//
	bg_gc        .create( get_window() , "white" );
	left_team_gc .create( get_window() , "gold"  );
	right_team_gc.create( get_window() , "red"   );
	string_gc    .create( get_window() , "black" );


	//
	// draw background pixmap
	//
	draw_background_to_pixmap( background_pixmap ,
				   model.inverse_x() );
	draw_background_to_pixmap( time_pixmap , model.inverse_x() );


	//
	// new pixmap
	//
	pixmap.set_background( background_pixmap );

	pixmap.create( get_window() , width() , height() );



	//
	// draw background
	//
	this -> get_window().set_back_pixmap( background_pixmap , false );


	//
	// Font
	//
	std::vector<std::string>	font_list;

	font_list.push_back
		( "-adobe-helvetica-*-r-normal--24-240-75-75-p-*-iso8859-1" );
	font_list.push_back( "7x14bold" );
	font_list.push_back( "-*-*-*-r-normal--10-*-*-*-p-*-iso8859-1" );
	font_list.push_back( "-*-*-*-r-normal--8-*-*-*-p-*-iso8859-1" );


	//
	// calculate message position
	//
	size_t	i;
	for ( i = 0  ;  i < font_list.size()  ;  i ++ )
	{
		mode_line_font.set_load( font_list[i] );

		if ( calculate_message_position
		     ( model ,
		       mode_line_font ,
		       static_cast<gint>(width() * (1.0 - 2.0 * SIDE_RATIO)) ,
		       &(this -> play_mode_draw_offset) ,
		       &(this -> time_draw_offset) ,
		       &(this -> max_number_char_width) ) )
		{
			break;
		}
	}
	this -> too_nallow = (i == font_list.size());


	this -> have_cache = false;

	this -> initialized = true;


	//
	// draw
	//
	this -> display();

	return( true );
}


gint   Game_Info_Mode_Line::expose_event_impl( GdkEventExpose *  event )
{
	get_window().draw_pixmap( pixmap.gc() ,
				  pixmap ,
				  event -> area.x , event -> area.y ,
				  event -> area.x , event -> area.y ,
				  event -> area.width , event-> area.height );
	pixmap.drawn();

	return( false );
}

void   Game_Info_Mode_Line::display()
{
	if ( ! initialized )
	{
		return;
	}


	if ( have_cache
	  && model.valid()
	  && this -> inverse_x_cache == model.inverse_x()
	  && this -> play_mode_cache == model.play_mode()
	  && this -> left_teamname_cache == model.left_teamname()
	  && this -> right_teamname_cache == model.right_teamname()
	  && this -> left_score_cache == model.left_score()
	  && this -> right_score_cache == model.right_score() )
	{
		this -> draw_time_only( pixmap , model.step() );
	}
	else
	{
		if ( this -> too_nallow && model.valid() )
		{
			calculate_nallow_message_position
				( this ->  mode_line_font ,
				  static_cast<gint>
				    ( width() * (1.0 - 2.0 * SIDE_RATIO) ) ,
				  model.play_mode() ,
				  &(this -> play_mode_draw_offset) ,
				  &(this -> time_draw_offset) ,
				  max_number_char_width );
		}

		this -> draw_all( pixmap );
	}
}

bool   Game_Info_Mode_Line::calculate_message_position
				( const Model  &  model ,
				  const Gdk_Font &  font ,
				  gint  w ,
				  gint *  play_mode_draw_offset ,
				  gint *  time_draw_offset ,
				  gint *  max_number_char_width )
{
	std::vector<Monitor_View_Data::Monitor_Play_Mode>	mode_list
		= Monitor_View_Data::Monitor_Play_Mode::mode_list();

	gint	max_play_mode_width = 0;

	for ( size_t  i = 0  ;  i < mode_list.size()  ;  i ++ )
	{
		gint	lbearing;
		gint	rbearing;
		gint	text_width;
		gint	ascent;
		gint	descent;

		if ( model.valid() )
		{
			font.string_extents( mode_list[i].play_mode_str
					     ( model.left_teamname() ,
					       model.right_teamname() ) ,
					     lbearing , rbearing ,
					     text_width ,
					     ascent , descent );
		}
		else
		{
			font.string_extents( mode_list[i].play_mode_str() ,
					     lbearing , rbearing ,
					     text_width ,
					     ascent , descent );
		}

		if ( max_play_mode_width < text_width )
		{
			max_play_mode_width = (rbearing - lbearing);
		}
	}

	const std::string	numbers = "-0123456789";
	for( size_t  i = 0  ;  i < numbers.length()  ;  i ++ )
	{
		gint	w = font.char_width( numbers[i] );
		if ( w > *max_number_char_width )
		{
			*max_number_char_width = w;
		}
	}

	gint	rest = w - (*max_number_char_width) * 5
			 - max_play_mode_width;

	*play_mode_draw_offset = (rest * 3) / 7;
	*time_draw_offset = *play_mode_draw_offset
				+ max_play_mode_width
				+ (rest * 1) / 7;

	return( (rest >= 0) );
}

bool   Game_Info_Mode_Line::calculate_nallow_message_position
		    ( const Gdk_Font &  font ,
		      gint  w ,
		      const std::string &  play_mode ,
		      gint *  play_mode_draw_offset ,
		      gint *  time_draw_offset ,
		      gint  max_number_char_width )
{
	gint	lbearing;
	gint	rbearing;
	gint	text_width;
	gint	ascent;
	gint	descent;

	font.string_extents( play_mode ,
			     lbearing , rbearing ,
			     text_width ,
			     ascent , descent );

	gint	play_mode_width = (rbearing - lbearing);

	gint	rest = w - (max_number_char_width) * 5
			 - play_mode_width;

	*play_mode_draw_offset = (rest * 3) / 7;
	*time_draw_offset = *play_mode_draw_offset
				+ play_mode_width
				+ (rest * 1) / 7;

	return( (rest >= 0) );
}


void   Game_Info_Mode_Line::draw_background_to_pixmap( Gdk_Pixmap &  pix ,
						       bool  inverse )
{
	Gdk_GC_Wrapper *	left_gc;
	Gdk_GC_Wrapper *	right_gc;

	if ( ! inverse )
	{
		left_gc  = &left_team_gc;
		right_gc = &right_team_gc;
	}
	else
	{
		left_gc  = &right_team_gc;
		right_gc = &left_team_gc;
	}


	// left bg
	pix.draw_rectangle( *left_gc ,
			    true ,
			    0 ,
			    0 ,
			    static_cast<gint>( width() * SIDE_RATIO ) ,
			    height() );

	// middle bg
	pix.draw_rectangle( bg_gc ,
			    true ,
			    static_cast<gint>( width() * SIDE_RATIO ) ,
			    0 ,
			    static_cast<gint>( width() * (1.0 - SIDE_RATIO) ) ,
			    height() );

	// right bg
	pix.draw_rectangle( *right_gc ,
			    true ,
			    static_cast<gint>( width() * (1.0 - SIDE_RATIO) ) ,
			    0 ,
			    width() ,
			    height() );
}


void   Game_Info_Mode_Line::draw_all( Transparent_Pixmap &  pix )
{
	pixmap.clear();

	if ( ! model.valid() )
	{
		this -> draw_time_to_pixmap( pix , time_pixmap ,
					     model.step() );

		//
		// draw to drawing area
		//
		this -> draw( Gdk_Rectangle( 0 ,
					     0 ,
					     this -> width() ,
					     this -> height() ) );

		this -> have_cache = false;

		return;
	}


	draw_background_to_pixmap( background_pixmap ,
				   model.inverse_x() );
	draw_background_to_pixmap( time_pixmap , model.inverse_x() );

	pix.draw_pixmap( bg_gc ,
			 background_pixmap ,
			 0 , 0 , 0 , 0 ,
			 pix.width() , pix.height() );

	//
	// make team name and score cache
	//
	if ( model.valid() )
	{
		if ( model.inverse_x() )
		{
			this -> left_teamname_cache  = model.right_teamname();
			this -> left_score_cache     = model.right_score();
			this -> right_teamname_cache = model.left_teamname();
			this -> right_score_cache    = model.left_score();
		}
		else
		{
			this -> left_teamname_cache  = model.left_teamname();
			this -> left_score_cache     = model.left_score();
			this -> right_teamname_cache = model.right_teamname();
			this -> right_score_cache    = model.right_score();
		}
	}

	//
	// draw left team name and score to pixmap
	//
	if ( left_teamname_cache.length() != 0 )
	{
		gchar		buf[256];
		strstream	buf_stream( buf , sizeof(buf) );

		buf_stream << (this -> left_teamname_cache)
			   << ": " << (this -> left_score_cache)
			   << ends;

		std::string	new_left_team_string = buf_stream.str();

		gint	lbearing;
		gint	rbearing;
		gint	text_width;
		gint	ascent;
		gint	descent;

		mode_line_font.string_extents( new_left_team_string ,
					       lbearing , rbearing ,
					       text_width ,
					       ascent , descent );

		pix.draw_string( mode_line_font ,
				 string_gc ,
				 lbearing
				   + 3 /* offset pixcel */ ,
				 (height() + ascent) / 2 ,
				 new_left_team_string );
	}


	//
	// draw right team name and score to pixmap
	//
	if ( right_teamname_cache.length() != 0 )
	{
		gchar		buf[256];
		strstream	buf_stream( buf , sizeof(buf) );

		buf_stream << (this -> right_teamname_cache)
			   << ": " << (this -> right_score_cache)
			   << ends;

		std::string	new_right_team_string = buf_stream.str();

		gint	lbearing;
		gint	rbearing;
		gint	text_width;
		gint	ascent;
		gint	descent;

		mode_line_font.string_extents( new_right_team_string ,
					       lbearing , rbearing ,
					       text_width ,
					       ascent , descent );

		pix.draw_string( mode_line_font ,
				 string_gc ,
				 width() - (lbearing + rbearing)
				   - 3 /* offset pixcel */ ,
				 (height() + ascent) / 2 ,
				 new_right_team_string );
	}

	//
	// draw play mode to pixmap
	//
	if ( model.valid() )
	{
		this -> play_mode_cache = model.play_mode();
	}

	{
		gchar		buf[256];
		strstream	buf_stream( buf , sizeof(buf) );
		buf_stream << (this -> play_mode_cache) << ends;

		std::string	str = buf_stream.str();

		gint	lbearing;
		gint	rbearing;
		gint	text_width;
		gint	ascent;
		gint	descent;

		mode_line_font.string_extents( str ,
					       lbearing , rbearing ,
					       text_width ,
					       ascent , descent );

		pix.draw_string( mode_line_font ,
				 string_gc ,
				 static_cast<gint>( width() * SIDE_RATIO
						    + play_mode_draw_offset ) ,
				 (height() + ascent) / 2 ,
				 str );
	}

	this -> inverse_x_cache = model.inverse_x();

	this -> have_cache = true;


	//
	// draw time to pixmap
	//
	this -> draw_time_to_pixmap( pix , time_pixmap , model.step() );


	//
	// draw to drawing area
	//
	this -> draw( Gdk_Rectangle( 0 , 0 ,
				     this -> width() , this -> height() ) );
}


void   Game_Info_Mode_Line::draw_time_to_pixmap( Transparent_Pixmap &  pix ,
						 Gdk_Pixmap &  time_pix ,
						 glong  t )
{
	time_pix.draw_pixmap( bg_gc ,
			      background_pixmap ,
			      drawn_rectangle_min_x ,
			      drawn_rectangle_min_y ,
			      drawn_rectangle_min_x ,
			      drawn_rectangle_min_y ,
			      drawn_rectangle_width ,
			      drawn_rectangle_height );

	gchar		buf[256];
	strstream	buf_stream( buf , sizeof(buf) );
	buf_stream << t << ends;

	std::string	str = buf_stream.str();

	gint	lbearing;
	gint	rbearing;
	gint	text_width;
	gint	ascent;
	gint	descent;

	mode_line_font.string_extents( str ,
				       lbearing , rbearing ,
				       text_width ,
				       ascent , descent );

	gint	pos_x = static_cast<gint>( width() * SIDE_RATIO )
			  + time_draw_offset;
	gint	pos_y = (height() + ascent) / 2;

	gint	min_x = pos_x + lbearing;
	gint	max_x = pos_x + rbearing;
	gint	min_y = pos_y - ascent;
	gint	max_y = pos_y + descent;

	pix.draw_string( mode_line_font ,
			 string_gc ,
			 pos_x , pos_y ,
			 str );

	drawn_rectangle_min_x  = min_x;
	drawn_rectangle_min_y  = min_y;
	drawn_rectangle_width  = max_x - min_x + 1;
	drawn_rectangle_height = max_y - min_y + 1;
}



void   Game_Info_Mode_Line::draw_time_only( Transparent_Pixmap &  pix ,
					    glong  t )
{
	//
	// draw time to pixmap
	//
	pix.draw_pixmap( bg_gc ,
			 background_pixmap ,
			 drawn_rectangle_min_x , drawn_rectangle_min_y ,
			 drawn_rectangle_min_x , drawn_rectangle_min_y ,
			 drawn_rectangle_width , drawn_rectangle_height );

	time_pixmap.draw_pixmap( bg_gc ,
				 background_pixmap ,
				 drawn_rectangle_min_x ,
				 drawn_rectangle_min_y ,
				 drawn_rectangle_min_x ,
				 drawn_rectangle_min_y ,
				 drawn_rectangle_width ,
				 drawn_rectangle_height );

	gchar		buf[256];
	strstream	buf_stream( buf , sizeof(buf) );
	buf_stream << t << ends;

	std::string	str = buf_stream.str();

	gint	lbearing;
	gint	rbearing;
	gint	text_width;
	gint	ascent;
	gint	descent;

	mode_line_font.string_extents( str ,
				       lbearing , rbearing ,
				       text_width ,
				       ascent , descent );

	gint	pos_x = static_cast<gint>( width() * SIDE_RATIO )
			  + time_draw_offset;
	gint	pos_y = (height() + ascent) / 2;

	gint	min_x = pos_x + lbearing;
	gint	max_x = pos_x + rbearing;
	gint	min_y = pos_y - ascent;
	gint	max_y = pos_y + descent;

	pix.draw_string( mode_line_font ,
			 string_gc ,
			 pos_x , pos_y ,
			 str );

	time_pixmap.draw_string( mode_line_font ,
				 string_gc ,
				 pos_x , pos_y ,
				 str );

	gint	clip_x_min  = std::min( drawn_rectangle_min_x , min_x );
	gint	clip_y_min  = std::min( drawn_rectangle_min_y , min_y );

	gint	clip_width  = std::max( drawn_rectangle_min_x
				         + drawn_rectangle_width ,
				       max_x )
			      - clip_x_min;
	gint	clip_height = std::max( drawn_rectangle_min_y
					  + drawn_rectangle_height ,
					max_y )
			      - clip_y_min;

	drawn_rectangle_min_x  = min_x;
	drawn_rectangle_min_y  = min_y;
	drawn_rectangle_width  = max_x - min_x + 1;
	drawn_rectangle_height = max_y - min_y + 1;

	get_window().draw_pixmap( bg_gc ,
				  time_pixmap ,
				  clip_x_min , clip_y_min ,
				  clip_x_min , clip_y_min ,
				  clip_width , clip_height );
}
