#ifndef	   GAME_INFO_MODE_LINE_VIEW_H_INCLUDED
#define	   GAME_INFO_MODE_LINE_VIEW_H_INCLUDED

#include  <gtk--.h>
#include  "transparent_pixmap.h"
#include  "gdk_gc_wrapper.h"
#include  <string>

class  Game_Info_Mode_Line : public Gtk::DrawingArea
{
public:
	class  Model
	{
	public:
			 Model(){}
		virtual	~Model(){}
		virtual	bool		valid() const = 0;
		virtual	std::string	left_teamname() const = 0;
		virtual	std::string	right_teamname() const = 0;
		virtual	gint		left_score() const = 0;
		virtual	gint		right_score() const = 0;
		virtual	std::string	play_mode() const = 0;
		virtual	gboolean	inverse_x() const = 0;
		virtual	glong		step() const = 0;
	};

protected:
	static	const	gint	DEFAULT_WIDTH;
	static	const	gint	DEFAULT_HEIGHT;

	static	const	gdouble	SIDE_RATIO;

protected:
	const Game_Info_Mode_Line::Model &	model;

protected:
	bool	initialized;

	Gdk_Pixmap		background_pixmap;
	Gdk_Pixmap		time_pixmap;
	Transparent_Pixmap	pixmap;

	Gdk_GC_Wrapper	bg_gc;
	Gdk_GC_Wrapper	left_team_gc;
	Gdk_GC_Wrapper	right_team_gc;

	Gdk_GC_Wrapper	string_gc;
	Gdk_Font	mode_line_font;

	gint		play_mode_draw_offset;
	gint		time_draw_offset;
	gint		max_number_char_width;
	gboolean	too_nallow;

	gboolean	have_cache;
	std::string	left_teamname_cache;
	std::string	right_teamname_cache;
	gint		left_score_cache;
	gint		right_score_cache;
	std::string	play_mode_cache;
	gboolean	inverse_x_cache;
	gboolean	use_teamname_cache;

	gint		drawn_rectangle_min_x;
	gint		drawn_rectangle_min_y;
	gint		drawn_rectangle_width;
	gint		drawn_rectangle_height;

protected:
	void	draw_background_to_pixmap( Gdk_Pixmap & ,  bool  inverse );

	void	draw_all( Transparent_Pixmap & );
	void	draw_time_to_pixmap( Transparent_Pixmap &  pix ,
				     Gdk_Pixmap &  time_pix ,
				     glong  t );

	void	draw_time_only( Transparent_Pixmap &  pix ,  glong  t );

	static	bool	calculate_message_position
			  ( const Game_Info_Mode_Line::Model  &  model ,
			    const Gdk_Font &  font ,
			    gint  w ,
			    gint *  play_mode_draw_offset ,
			    gint *  time_draw_offset ,
			    gint *  max_number_char_width );

	static	bool	calculate_nallow_message_position
			  ( const Gdk_Font &  font ,
			    gint  w ,
			    const std::string &  play_mode ,
			    gint *  play_mode_draw_offset ,
			    gint *  time_draw_offset ,
			    gint  max_number_char_width );

protected:
	virtual	gint	configure_event_impl( GdkEventConfigure * );
	virtual	gint	expose_event_impl( GdkEventExpose *  event );

public:
		 Game_Info_Mode_Line( const Game_Info_Mode_Line::Model & );
	virtual	~Game_Info_Mode_Line();

	virtual	void	display();
};


#endif	/* GAME_INFO_MODE_LINE_VIEW_H_INCLUDED */
