#ifndef	   COORDINATE_VIEW_PIXMAP_H_INCLUDED
#define	   COORDINATE_VIEW_PIXMAP_H_INCLUDED

#include  <gdk--.h>

template<class  Pixmap_Class>
class  Coordinate_View_Pixmap
{
protected:
	Pixmap_Class	pix;

	gdouble	origin_x;
	gdouble	origin_y;
	gdouble	ratio;

	gint	sign_x;
	gint	sign_y;

protected:
	void	set_view( gdouble  center_x , gdouble  center_y ,
			  gdouble  rat /* distance par pixel */ ,
			  bool  inverse_x ,  bool  inverse_y );

public:
	gint	x_coordinate_to_pixel( gdouble  x ) const;
	gint	y_coordinate_to_pixel( gdouble  y ) const;
	gdouble	x_pixel_to_coordinate( gint  x ) const;
	gdouble	y_pixel_to_coordinate( gint  x ) const;

	gint	coordinate_distance_to_pixel( gdouble  d ) const;
	gint	angle_convert( gdouble  ang ) const;

	gdouble	min_x();
	gdouble	max_x();
	gdouble	min_y();
	gdouble	max_y();

public:
	 Coordinate_View_Pixmap();
virtual	~Coordinate_View_Pixmap();

	Pixmap_Class &	entity();

	// overwrite
virtual	gint	width();
virtual	gint	height();

virtual	void	create( gint  width ,
			gint  height ,
			gint  depth = -1 );

virtual	void	create( const Gdk_Drawable &  drawable ,
			gint  width ,
			gint  height ,
			gint  depth = -1 );

	// addition
virtual	void	create( gdouble  center_x ,
			gdouble  center_y ,
			gdouble  ratio , /* distance par pixel */
			bool  inverse_x ,
			bool  inverse_y ,
			const Gdk_Drawable &  drawable ,
			gint  width ,
			gint  height ,
			gint  depth = -1 );

virtual	void	create( gdouble  center_x ,
			gdouble  center_y ,
			gdouble  ratio , /* distance par pixel */
			bool  inverse_x ,
			bool  inverse_y ,
			gint  width ,
			gint  height ,
			gint  depth = -1 );

virtual	void	draw_point_absolute( Gdk_GC &  gc ,
				     gdouble  x1 ,
				     gdouble  y1 );


virtual	void	draw_line_absolute( Gdk_GC &  gc ,
				    gdouble  x1 ,
				    gdouble  y1 ,
				    gdouble  x2 ,
				    gdouble  y2 );

virtual	void	draw_rectangle_absolute( Gdk_GC &  gc ,
					 gint  filled ,
					 gdouble  x ,
					 gdouble  y ,
					 gdouble  width ,
					 gdouble  height );

virtual	void	draw_arc_absolute( Gdk_GC &  gc ,
				   gint  filled ,
				   gdouble  x ,
				   gdouble  y ,
				   gdouble  width ,
				   gdouble  height ,
				   gdouble  angle1 ,
				   gdouble  angle2 );

virtual	void	draw_string_absolute( Gdk_Font &  font ,
				      Gdk_GC &  gc ,
				      gdouble  x,
				      gdouble  y,
				      const std::string &  str );


virtual	void	draw_rectangle_absolute_another_interface( Gdk_GC &  gc ,
							   gint  filled ,
							   gdouble  start_x ,
							   gdouble  start_y ,
							   gdouble  end_x ,
							   gdouble  end_y );

virtual	void	draw_arc_absolute_another_interface( Gdk_GC &  gc ,
						     gint  filled ,
						     gdouble  center_x ,
						     gdouble  center_y ,
						     gdouble  a ,
						     gdouble  b ,
						     gdouble  angle1 ,
						     gdouble  angle2 );
};


// ****************************************************************************
// *  implement
// ****************************************************************************
template<class  Pixmap_Class>
Coordinate_View_Pixmap<Pixmap_Class>::Coordinate_View_Pixmap()
	: origin_x( 0.0 ) , origin_y( 0.0 ) , ratio( 1.0 )
{
}

template<class  Pixmap_Class>
Coordinate_View_Pixmap<Pixmap_Class>::~Coordinate_View_Pixmap()
{
}

template<class  Pixmap_Class>
Pixmap_Class &  Coordinate_View_Pixmap<Pixmap_Class>::entity()
{
	return( pix );
}

template<class  Pixmap_Class>
gint  Coordinate_View_Pixmap<Pixmap_Class>::x_coordinate_to_pixel( gdouble  x )
	const
{
	gdouble	new_x;

	if ( x < 0.0 )
	{
		new_x = x - 0.5;
	}
	else if ( x > 0.0 )
	{
		new_x = x + 0.5;
	}

	return( static_cast<gint>( origin_x  +  (x * sign_x) / ratio ) );
}

template<class  Pixmap_Class>
gint  Coordinate_View_Pixmap<Pixmap_Class>::y_coordinate_to_pixel( gdouble  y )
	const
{
	gdouble	new_y;

	if ( y < 0.0 )
	{
		new_y = y - 0.5;
	}
	else if ( y > 0.0 )
	{
		new_y = y + 0.5;
	}

	return( static_cast<gint>( origin_y  +  (y * sign_y) / ratio ) );
}

template<class  Pixmap_Class>
gdouble  Coordinate_View_Pixmap<Pixmap_Class>::x_pixel_to_coordinate( gint  x )
	const
{
	return( ((x - origin_x) * ratio) * sign_x );
}

template<class  Pixmap_Class>
gdouble  Coordinate_View_Pixmap<Pixmap_Class>::y_pixel_to_coordinate( gint  y )
	const
{
	return( ((y - origin_y) * ratio) * sign_y );
}


template<class  Pixmap_Class>
gint   Coordinate_View_Pixmap<Pixmap_Class>
				::coordinate_distance_to_pixel( gdouble  d )
	const
{
	double	pix = d / ratio;

	if ( pix < 0.0 )
	{
		pix -= 0.5;
	}
	else if ( pix > 0.0 )
	{
		pix += 0.5;
	}

	gint	dist = static_cast<gint>( pix );

	if ( dist != 0 )
	{
		return( dist );
	}
	else
	{
		if ( d == 0.0 )
		{
			return( 0 );
		}
		if ( d > 0.0 )
		{
			return( 1 );
		}
		else
		{
			return( -1 );
		}
	}
}

template<class  Pixmap_Class>
gint   Coordinate_View_Pixmap<Pixmap_Class>::angle_convert( gdouble  org )
	const
{
	double	a = org * 64;

	if ( a < 0.0 )
	{
		a -= 0.5;
	}
	else if ( a > 0.0 )
	{
		a += 0.5;
	}

	return( static_cast<gint>( a ) );
}

template<class  Pixmap_Class>
gdouble  Coordinate_View_Pixmap<Pixmap_Class>::min_x()
{
	if ( sign_x >= 0 )
	{
		return( x_pixel_to_coordinate( 0 ) );
	}
	else
	{
		return( x_pixel_to_coordinate( ((this -> width() <= 1) ? 0
						: this -> width() - 1) ) );
	}
}

template<class  Pixmap_Class>
gdouble  Coordinate_View_Pixmap<Pixmap_Class>::max_x()
{
	if ( sign_x >= 0 )
	{
		return( x_pixel_to_coordinate( ((this -> width() <= 1) ? 0
						: this -> width() - 1) ) );
	}
	else
	{
		return( x_pixel_to_coordinate( 0 ) );
	}
}

template<class  Pixmap_Class>
gdouble  Coordinate_View_Pixmap<Pixmap_Class>::min_y()
{
	if ( sign_y >= 0 )
	{
		return( y_pixel_to_coordinate( 0 ) );
	}
	else
	{
		return( y_pixel_to_coordinate( ((this -> height() <= 1) ? 0
						: this -> height() - 1) ) );
	}
}

template<class  Pixmap_Class>
gdouble  Coordinate_View_Pixmap<Pixmap_Class>::max_y()
{
	if ( sign_y >= 0 )
	{
		return( y_pixel_to_coordinate( ((this -> height() <= 1) ? 0
						: this -> height() - 1) ) );
	}
	else
	{
		return( y_pixel_to_coordinate( 0 ) );
	}
}


template<class  Pixmap_Class>
void   Coordinate_View_Pixmap<Pixmap_Class>
	::set_view( gdouble  center_x , gdouble  center_y ,
		    gdouble  rat /* distance par pixel */ ,
		    bool  inverse_x ,  bool  inverse_y )
{
	sign_x = (+1) * ( (inverse_x) ? (-1) : (1) );
	sign_y = (-1) * ( (inverse_y) ? (-1) : (1) );

	origin_x = static_cast<gdouble>( pix.width() ) / 2.0
		   - sign_x * static_cast<gdouble>( center_x ) / ratio;

	origin_y = static_cast<gdouble>( pix.height() ) / 2.0
		   - sign_y * static_cast<gdouble>( center_y ) / ratio;

	ratio = rat;
}


template<class  Pixmap_Class>
gint   Coordinate_View_Pixmap<Pixmap_Class>::width()
{
	return( pix.width() );
}

template<class  Pixmap_Class>
gint   Coordinate_View_Pixmap<Pixmap_Class>::height()
{
	return( pix.height() );
}


template<class  Pixmap_Class>
void   Coordinate_View_Pixmap<Pixmap_Class>::create( gint  width ,
						     gint  height ,
						     gint  depth )
{
	pix.create( width , height , depth );

	this -> set_view( 0.0 , 0.0 , 1.0 , false , false );
}

template<class  Pixmap_Class>
void   Coordinate_View_Pixmap<Pixmap_Class>
	::create( const Gdk_Drawable &  drawable ,
		  gint  width ,  gint  height ,  gint  depth )
{
	pix.create( drawable , width , height , depth );

	this -> set_view( 0.0 , 0.0 , 1.0 , false , false );
}

template<class  Pixmap_Class>
void   Coordinate_View_Pixmap<Pixmap_Class>
	::create( gdouble  center_x , gdouble  center_y ,
		  gdouble  rat , /* distance par pixel */
		  bool  inverse_x ,
		  bool  inverse_y ,
		  const Gdk_Drawable &  drawable ,
		  gint  width ,  gint  height ,  gint  depth )
{
	pix.create( drawable , width , height , depth );

	this -> set_view( center_x , center_y , rat , inverse_x , inverse_y );
}

template<class  Pixmap_Class>
void   Coordinate_View_Pixmap<Pixmap_Class>
	::create( gdouble  center_x ,  gdouble  center_y ,
		  gdouble  rat , // distance par pixel
		  bool  inverse_x ,
		  bool  inverse_y ,
		  gint  width ,  gint  height ,  gint  depth )
{
	pix.create( width , height , depth );

	this -> set_view( center_x , center_y , rat , inverse_x , inverse_y );
}


//
// Draw in Absolute Coordinate
//
template<class  Pixmap_Class>
void   Coordinate_View_Pixmap<Pixmap_Class>
	::draw_point_absolute( Gdk_GC &  gc ,
			       gdouble  x1 ,  gdouble  y1 )
{
	pix.draw_point( gc ,
			x_coordinate_to_pixel( x1 ) ,
			y_coordinate_to_pixel( y1 ) );
}


template<class Pixmap_Class>
void   Coordinate_View_Pixmap<Pixmap_Class>::draw_line_absolute( Gdk_GC &  gc ,
								 gdouble  x1 ,
								 gdouble  y1 ,
								 gdouble  x2 ,
								 gdouble  y2 )
{
	pix.draw_line( gc ,
		       x_coordinate_to_pixel( x1 ) ,
		       y_coordinate_to_pixel( y1 ) ,
		       x_coordinate_to_pixel( x2 ) ,
		       y_coordinate_to_pixel( y2 ) );
}

template<class Pixmap_Class>
void   Coordinate_View_Pixmap<Pixmap_Class>
	::draw_rectangle_absolute( Gdk_GC &  gc ,
				   gint  filled ,
				   gdouble  x ,  gdouble  y ,
				   gdouble  width ,  gdouble  height )
{
	gdouble	start_x = ((sign_x == 1) ? x : x + width);
	gdouble	start_y = ((sign_y == 1) ? y : y + height);

	pix.draw_rectangle( gc ,
			    filled ,
			    x_coordinate_to_pixel( start_x ) ,
			    y_coordinate_to_pixel( start_y ) ,
			    coordinate_distance_to_pixel( width ) ,
			    coordinate_distance_to_pixel( height ) );
}

template<class Pixmap_Class>
void   Coordinate_View_Pixmap<Pixmap_Class>
	::draw_arc_absolute( Gdk_GC &  gc ,
			     gint  filled ,
			     gdouble  x ,  gdouble  y ,
			     gdouble  width ,  gdouble  height ,
			     gdouble  angle1 ,  gdouble  angle2 )
{
	gdouble	start_x = ((sign_x == 1) ? x : x + width);
	gdouble	start_y = ((sign_y == 1) ? y : y + height);

	gdouble	start_angle = angle1;

	if ( sign_x == (-1) )
	{
		start_angle = 180.0 - start_angle;
	}

	if ( sign_y == 1 )
	{
		start_angle = (- start_angle);
	}

	if ( (sign_x * sign_y) == 1 )
	{
		start_angle -= angle2;
	}

	pix.draw_arc( gc ,
		      filled ,
		      x_coordinate_to_pixel( start_x ) ,
		      y_coordinate_to_pixel( start_y ) ,
		      coordinate_distance_to_pixel( width ) ,
		      coordinate_distance_to_pixel( height ) ,
		      angle_convert( start_angle ) ,
		      angle_convert( angle2 ) );
}

template<class Pixmap_Class>
void   Coordinate_View_Pixmap<Pixmap_Class>
	::draw_string_absolute( Gdk_Font &  font ,
				Gdk_GC &  gc ,
				gdouble  x ,  gdouble  y ,
				const std::string &  str )
{
	pix.draw_string( font ,
			 gc ,
			 x_coordinate_to_pixel( x ) ,
			 y_coordinate_to_pixel( y ) ,
			 str );
}


//
// Another Interface
//
template<class Pixmap_Class>
void   Coordinate_View_Pixmap<Pixmap_Class>
	::draw_rectangle_absolute_another_interface(
	   Gdk_GC &  gc ,
	   gint  filled ,
	   gdouble  start_x ,  gdouble  start_y ,
	   gdouble  end_x ,  gdouble  end_y )
{
	this -> draw_rectangle_absolute( gc ,
					 filled ,
					 start_x ,
					 start_y ,
					 (end_x - start_x) ,
					 (end_y - start_y) );
}

template<class Pixmap_Class>
void   Coordinate_View_Pixmap<Pixmap_Class>
	::draw_arc_absolute_another_interface(
	   Gdk_GC &  gc ,
	   gint  filled ,
	   gdouble  center_x , gdouble  center_y ,
	   gdouble  a ,  gdouble  b ,
	   gdouble  angle1 ,  gdouble  angle2 )
{
	this -> draw_arc_absolute( gc ,
				   filled ,
				   center_x - a ,
				   center_y - b ,
				   a * 2.0 ,
				   b * 2.0 ,
				   angle1 ,
				   angle2 );
}

#endif	/* COORDINATE_VIEW_PIXMAP_H_INCLUDED */
