#ifndef	   GDK_GC_WRAPPER_H_INCLUDED
#define	   GDK_GC_WRAPPER_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	May 15 2000
// Created:		May 15 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  May 15 2000    base version.
//
//

#include  <gdk--.h>
#include  <string>

class  Gdk_GC_Wrapper : public Gdk_GC
{
public:
	Gdk_GC_Wrapper() : Gdk_GC() {}
	Gdk_GC_Wrapper( GdkGC *  gc ) : Gdk_GC( gc ) {}
	Gdk_GC_Wrapper( Gdk_Drawable &  drawable ) : Gdk_GC( drawable ) {}

	Gdk_GC_Wrapper( Gdk_Drawable &  drawable ,
			const std::string &  fg_color )
		: Gdk_GC( drawable )
	{
		this -> set_foreground( fg_color );
	}

	Gdk_GC_Wrapper( Gdk_Drawable &  drawable ,
			const std::string &  fg_color ,
			const std::string &  bg_color )
		: Gdk_GC( drawable )
	{
		this -> set_foreground( fg_color );
		this -> set_background( bg_color );
	}

	virtual	~Gdk_GC_Wrapper(){}

	virtual	void	create( const Gdk_Drawable &  drawable )
	{
		this -> Gdk_GC::create( drawable );
	}

	virtual	void	create( const Gdk_Drawable &  drawable ,
				const std::string &  fg_color )
	{
		this -> Gdk_GC::create( drawable );
		this -> set_foreground( fg_color );
	}

	virtual	void	create( const Gdk_Drawable &  drawable ,
				const std::string &  fg_color ,
				const std::string &  bg_color )
	{
		this -> Gdk_GC::create( drawable );
		this -> set_foreground( fg_color );
		this -> set_background( bg_color );
	}

	virtual	void	set_foreground( const std::string &  fg_color )
	{
		Gdk_Color	color( fg_color.c_str() );
		Gdk_Colormap::get_system().alloc( color );

		this -> Gdk_GC::set_foreground( color );
	}

	virtual	void	set_background( const std::string &  fg_color )
	{
		Gdk_Color	color( fg_color.c_str() );
		Gdk_Colormap::get_system().alloc( color );

		this -> Gdk_GC::set_background( color );
	}
};


#endif	/* GDK_GC_WRAPPER_H_INCLUDED */
