#include  "transparent_pixmap.h"
#include  "gdk_gc_wrapper.h"
#include  <unistd.h>
#include  <gtk--.h>

class  Transparent_Pixmap_Test : public Gtk::Window
{
private:
	bool			initialized;
	Transparent_Pixmap	pixmap;
	Gdk_Pixmap		background;
	int			count;
	Gdk_GC_Wrapper		bg_gc;
	Gdk_GC_Wrapper		gc;

public:
	Transparent_Pixmap_Test()
		: initialized( false ) , count( 0 )
	{
		this -> set_default_size( 900 , 600 );
	}

	gint	delete_event_impl( GdkEventAny * )
	{
		Gtk::Main::quit();

		return( false );
	}

	gint	configure_event_impl( GdkEventConfigure * )
	{
		cout << "configure_event" << endl;

		//
		// GC
		//
		bg_gc.create( get_window() , "forestgreen" );
		gc.create( get_window() , "blue" );

		//
		// background pixmap
		//
		background.create( get_window() , width() , height() );


		//
		// draw background
		//
		background.draw_rectangle( bg_gc , true ,
					   0.0 , 0.0 ,
					   background.width() ,
					   background.height() );

		//
		// pixmap
		//
		pixmap.set_background( background );
		pixmap.create( get_window() , width() , height() );


		//
		// draw background
		//
		this -> get_window().set_back_pixmap( background , false );

		initialized = true;

		return( true );
	}

	gint	expose_event_impl( GdkEventExpose *  event )
	{
		cout << "expose_event" << endl;

		get_window().draw_pixmap( pixmap.gc() ,
					  pixmap ,
					  0 , 0 ,
					  0 , 0 ,
					  width() , height() );
		pixmap.drawn();

		return( false );
	}

	gint	update()
	{
		if ( ! initialized )
		{
			return( true );
		}

		cout << count << endl;

		pixmap.clear();

		pixmap.draw_arc( gc ,
				 true ,
				 count * 10 , count * 10 ,
				 50 , 50 ,
				 0 * 64 , 360 * 64 );

		pixmap.draw_arc( gc ,
				 true ,
				 500 - count * 10 , 500 - count * 10 ,
				 50 , 50 ,
				 0 * 64 , 360 * 64 );

		get_window().draw_pixmap( pixmap.gc() ,
					  pixmap ,
					  0 , 0 ,
					  0 , 0 ,
					  width() , height() );

		pixmap.drawn();

		count ++;

		if ( count >= 50 )
		{
			count = 0;
		}

		return( true );
	}
};

int    main( int  argc ,  char *  argv[] )
{
	Gtk::Main	gtk( &argc , &argv );

	Transparent_Pixmap_Test	win;

	Gtk::Main::timeout.connect
	 ( SigC::slot( &win , &Transparent_Pixmap_Test::update ) ,
	   100 /* msec */ );

	win.show();

	gtk.run();

	return( 0 );
}
