#include  "transparent_pixmap.h"
#include  <cmath>
#include  <algorithm>

Transparent_Pixmap::Transparent_Pixmap()
	: cleared( true )
{
}

Transparent_Pixmap::~Transparent_Pixmap()
{
}


void   Transparent_Pixmap::add_rectangle_clip_region( gint  x , gint  y ,
						      gint  w , gint  h )
{
	if ( w != 0 && h != 0 )
	{
		new_clip_region
			= new_clip_region.add_rectangle( x , y , w , h );
	}
}

gint   Transparent_Pixmap::gc_line_width( const Gdk_GC &  gc )
{
	GdkGCValues	values;
	const_cast<Gdk_GC &>(gc).get_values( values );

	return( values.line_width + 1 );
}


void   Transparent_Pixmap::set_background( /*const*/ Gdk_Pixmap &  pix )
{
	background = pix;
}

Gdk_GC &  Transparent_Pixmap::gc()
{
	clip_region = new_clip_region.add_region( old_clip_region );

	gdk_gc_set_clip_region( clip_gc , clip_region.get_region() );

	return( clip_gc );
}

void   Transparent_Pixmap::create( const Gdk_Drawable &  drawable ,
				   gint  width ,
				   gint  height ,
				   gint  depth )
{
	this -> Gdk_Pixmap::create( drawable , width , height , depth );
	clip_gc.create( *this );

	old_clip_region = old_clip_region.new_region();
	new_clip_region = new_clip_region.new_region();

	this -> add_rectangle_clip_region( 0 , 0 , width , height );

	if ( background )
	{
		Gdk_Pixmap::draw_pixmap( clip_gc , background ,
					 0 , 0 , 0 , 0 , width , height );
	}
}

void   Transparent_Pixmap::create( gint  width ,
				   gint  height ,
				   gint  depth )
{
	this -> Gdk_Pixmap::create( width , height , depth );
	clip_gc.create( *this );

	old_clip_region = old_clip_region.new_region();
	new_clip_region = new_clip_region.new_region();

	this -> add_rectangle_clip_region( 0 , 0 , width , height );

	if ( background )
	{
		Gdk_Pixmap::draw_pixmap( clip_gc , background ,
					 0 , 0 , 0 , 0 , width , height );
	}
}

void   Transparent_Pixmap::drawn()
{
	if ( cleared )
	{
		if ( old_clip_region.get_region() )
		{
			gdk_gc_set_clip_region( clip_gc ,
						old_clip_region.get_region() );

			old_clip_region = old_clip_region.destroy_region();
		}

		old_clip_region = new_clip_region;
		new_clip_region = new_clip_region.new_region();

		cleared = false;
	}
}

void   Transparent_Pixmap::clear()
{
	if ( background )
	{
		this -> Gdk_Pixmap::draw_pixmap( this -> gc() ,
						 background ,
						 0 , 0 ,
						 0 , 0 );
	}

	cleared = true;
}




// ****************************************************************************
// ****************************************************************************
//
//  overwrite draw_*
//
// ****************************************************************************
// ****************************************************************************

void   Transparent_Pixmap::draw_point( Gdk_GC &  gc  ,
				       gint  x ,  gint  y )
{
	Gdk_Pixmap::draw_point( gc , x , y );

	this -> add_rectangle_clip_region( x , y , 1 , 1 );
}

void   Transparent_Pixmap::draw_points( Gdk_GC &  gc ,
					GdkPoint *  points ,  gint  npoints )
{
	Gdk_Pixmap::draw_points( gc , points , npoints );

	for ( gint i = 0  ;  i < npoints  ;  i ++ )
	{
		this -> add_rectangle_clip_region( points[i].x , points[i].y ,
						   1 , 1 );
	}
}

void   Transparent_Pixmap::draw_line( Gdk_GC &  gc ,
				      gint  x1 ,  gint  y1 ,
				      gint  x2 ,  gint  y2 )
{
	Gdk_Pixmap::draw_line( gc , x1 , y1 , x2 , y2 );

	gint	w = this -> gc_line_width( gc );

	this -> add_rectangle_clip_region( std::min( x1 , x2 ) - w ,
					   std::min( y1 , y2 ) - w ,
					   std::abs( x2 - x1 ) + w * 2 ,
					   std::abs( y2 - y1 ) + w * 2 );
}

void   Transparent_Pixmap::draw_lines( Gdk_GC &  gc ,
				       const Gdk_Points &  points )
{
	Gdk_Pixmap::draw_lines( gc , points );

	gint	w = this -> gc_line_width( gc );

	for ( gint i = 1  ;  i < points.size()  ;  i ++ )
	{
		this -> add_rectangle_clip_region
			( std::min( points[i - 1].x , points[i].x) - w ,
			  std::min( points[i - 1].y , points[i].y) - w ,
			  std::abs( points[i].x - points[i - 1].x ) + w * 2 ,
			  std::abs( points[i].y - points[i - 1].y ) + w * 2 );
	}
}

void   Transparent_Pixmap::draw_lines( Gdk_GC &  gc ,
				       GdkPoint *  points ,  gint  npoints )
{
	Gdk_Pixmap::draw_lines( gc , points , npoints );

	gint	w = this -> gc_line_width( gc );

	for ( gint i = 1  ;  i < npoints  ;  i ++ )
	{
		this -> add_rectangle_clip_region
			( std::min( points[i - 1].x , points[i].x) - w ,
			  std::min( points[i - 1].y , points[i].y) - w ,
			  std::abs( points[i].x - points[i - 1].x ) + w * 2 ,
			  std::abs( points[i].y - points[i - 1].y ) + w * 2 );
	}
}



void   Transparent_Pixmap::draw_arc( Gdk_GC &  gc ,
				     gint  filled ,
				     gint  x ,  gint  y ,
				     gint  width  ,  gint  height ,
				     gint  angle1 ,  gint  angle2 )
{
	Gdk_Pixmap::draw_arc( gc , filled ,
			      x , y , width , height , angle1 , angle2 );

	gint	w = this -> gc_line_width( gc );

	this -> add_rectangle_clip_region( x - w , y - w ,
					   width + w * 2 , height + w * 2 );
}

void   Transparent_Pixmap::draw_rectangle( Gdk_GC &  gc ,
					   gint  filled ,
					   gint  x ,  gint  y ,
					   gint  width ,  gint  height )
{
	Gdk_Pixmap::draw_rectangle( gc , filled ,
				    x , y , width , height );

	this -> add_rectangle_clip_region( x , y ,
					   width , height );
}

void   Transparent_Pixmap::draw_pixmap( Gdk_GC &  gc ,
					Gdk_Drawable &  src ,
					gint  xsrc ,  gint  ysrc ,
					gint  xdest ,  gint  ydest ,
					gint  width ,  gint  height )
{
	Gdk_Pixmap::draw_pixmap( gc ,
				 src ,
				 xsrc , ysrc ,
				 xdest , ydest ,
				 width , height );

	this -> add_rectangle_clip_region( xdest , ydest , width , height );
}

void   Transparent_Pixmap::draw_bitmap( Gdk_GC &  gc ,
					Gdk_Bitmap &  src ,
					gint xsrc ,  gint  ysrc ,
					gint  xdest ,  gint  ydest ,
					gint  width ,  gint  height )
{
	Gdk_Pixmap::draw_bitmap( gc ,
				 src ,
				 xsrc , ysrc ,
				 xdest , ydest ,
				 width , height );

	this -> add_rectangle_clip_region( xdest , ydest , width , height );
}


void   Transparent_Pixmap::draw_image( Gdk_GC &  gc ,
				       Gdk_Image &  image ,
				       gint  xsrc ,  gint  ysrc ,
				       gint  xdest ,  gint  ydest ,
				       gint  width ,  gint  height )
{
	Gdk_Pixmap::draw_image( gc , image , xsrc , ysrc , xdest , ydest ,
				width , height );

	this -> add_rectangle_clip_region( xdest , ydest , width , height );
}


void   Transparent_Pixmap::draw_string( Gdk_Font &  font ,
					Gdk_GC &  gc ,
					gint  x ,  gint  y ,
					const std::string &  str )
{
	Gdk_Pixmap::draw_string( font , gc , x , y , str );

	gint	lbearing;
	gint	rbearing;
	gint	width;
	gint	ascent;
	gint	descent;

	font.string_extents( str ,
			     lbearing , rbearing , width , ascent , descent );

	this -> add_rectangle_clip_region( x + lbearing ,
					   y - ascent ,
					   lbearing + rbearing ,
					   ascent + descent );
}

void   Transparent_Pixmap::draw_text( Gdk_Font &  font ,
				      Gdk_GC &  gc ,
				      gint  x ,  gint  y ,
				      const std::string &  text ,
				      gint  text_length )
{
	Gdk_Pixmap::draw_text( font , gc , x , y ,
			       text.c_str() , text_length );

	gint	lbearing;
	gint	rbearing;
	gint	width;
	gint	ascent;
	gint	descent;

	font.text_extents( text.c_str() , text_length ,
			   lbearing , rbearing , width , ascent , descent );

	this -> add_rectangle_clip_region( x + lbearing ,
					   y - ascent ,
					   lbearing + rbearing ,
					   ascent + descent );
}
