#ifndef	   TRANSPARENT_PIXMAP_H_INCLUDED
#define	   TRANSPARENT_PIXMAP_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	May 26 2000
// Created:		May 26 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  May 26 2000    base version.
//
//

#include  <gdk--.h>
#include  <string>
#include  "ref_count_ptr.h"

class  Transparent_Pixmap : public Gdk_Pixmap
{
protected:
	struct  Region
	{
		GdkRegion *	region;

	public:
		// Not allowed!!
		Region( const Region & );

		// Not allowed!!
		Region &  operator= ( const Region & );

	public:
		Region( GdkRegion *  r = static_cast<GdkRegion *>(0) )
			: region( r )
		{
		}

		~Region()
		{
			if ( region )
			{
				gdk_region_destroy( region );
			}
		}
	};

	class  Region_Wrapper
	{
	protected:
		ref_count_ptr<Region>	region;

	public:
		Region_Wrapper( const ref_count_ptr<Region> &  r
						= static_cast<Region *>(0) )
			: region( r ) {}

		GdkRegion *	get_region() const
		{
			return( region -> region );
		}

		Region_Wrapper	destroy_region()
		{
			ref_count_ptr<Region>	n( static_cast<Region *>(0) );
			return( n );
		}

		Region_Wrapper	new_region()
		{
			ref_count_ptr<Region>	n;

			n = new Region( gdk_region_new() );

			return( n );
		}

		Region_Wrapper	add_region( const Region_Wrapper &  r )
		{
			if ( gdk_region_equal( this -> get_region() ,
					       r.get_region() ) )
			{
				return( *this );
			}

			ref_count_ptr<Region>	n;

			n = new Region( gdk_regions_union
					( this -> get_region() ,
					  r.get_region() ) );
			return( n );
		}

		Region_Wrapper	add_rectangle( gint  x , gint  y ,
					       gint  w , gint  h )
		{
			GdkRectangle	rect;

			rect.x = x;
			rect.y = y;
			rect.width  = w;
			rect.height = h;

			ref_count_ptr<Region>	r;

			r = new Region( gdk_region_union_with_rect
					  ( this -> get_region() ,  &rect ) );
			return( r );
		}

	};

protected:
	Region_Wrapper	old_clip_region;
	Region_Wrapper	new_clip_region;

	Region_Wrapper	clip_region;
	Gdk_GC		clip_gc;

	bool		cleared;

	Gdk_Pixmap	background;

protected:
	virtual	void	add_rectangle_clip_region( gint  x , gint  y ,
						   gint  w , gint  h );

	virtual	gint	gc_line_width( const Gdk_GC &  gc );

public:
		 Transparent_Pixmap();
	virtual	~Transparent_Pixmap();

	virtual	void		create( const Gdk_Drawable &  drawable ,
					gint  width ,
					gint  height ,
					gint  depth = -1 );

	virtual	void		create( gint  width ,
					gint  height ,
					gint  depth = -1 );

	virtual	void		set_background( /*const*/ Gdk_Pixmap &  pix );

	virtual	Gdk_GC &	gc();

	virtual	void		drawn();

	virtual	void		clear();

	virtual	void		draw_point( Gdk_GC &  gc  ,
					    gint  x ,  gint  y );

	virtual	void		draw_points( Gdk_GC &  gc ,
					     GdkPoint *  points ,
					     gint  npoints );

	virtual	void		draw_line( Gdk_GC &  gc ,
					   gint  x1 ,  gint  y1 ,
					   gint  x2 ,  gint  y2 );

	virtual	void		draw_lines( Gdk_GC &  gc ,
					    const Gdk_Points &  points );

	virtual	void		draw_lines( Gdk_GC &  gc ,
					    GdkPoint *  points ,
					    gint  npoints );

	virtual	void		draw_arc( Gdk_GC &  gc ,
					  gint  filled ,
					  gint  x ,  gint  y ,
					  gint  width  ,  gint  height ,
					  gint  angle1 ,  gint  angle2 );

	virtual	void		draw_rectangle( Gdk_GC &  gc ,
						gint  filled ,
						gint  x ,  gint  y ,
						gint  width ,  gint  height );

	virtual	void		draw_pixmap( Gdk_GC &  gc ,
					     Gdk_Drawable &  src ,
					     gint  xsrc ,  gint  ysrc ,
					     gint  xdest ,  gint  ydest ,
					     gint  width ,  gint  height );

	virtual	void		draw_bitmap( Gdk_GC &  gc ,
					     Gdk_Bitmap &  src ,
					     gint xsrc ,  gint  ysrc ,
					     gint  xdest ,  gint  ydest ,
					     gint  width = -1 ,
					     gint  height = -1 );

	virtual	void		draw_image( Gdk_GC &  gc ,
					    Gdk_Image &  image ,
					    gint  xsrc ,  gint  ysrc ,
					    gint  xdest ,  gint  ydest ,
					    gint  width = -1 ,
					    gint  height = -1 );


	virtual	void		draw_string( Gdk_Font &  font ,
					     Gdk_GC &  gc ,
					     gint  x ,  gint  y ,
					     const std::string &  str );

	virtual	void		draw_text( Gdk_Font &  font ,
					   Gdk_GC &  gc ,
					   gint  x ,  gint  y ,
					   const std::string &  str ,
					   gint  text_length );
};


#endif	/* TRANSPARENT_PIXMAP_H_INCLUDED */
