#include  "gtk_updator.h"

Gtk_Updator::Gtk_Updator()
{
}

Gtk_Updator::~Gtk_Updator()
{
}

void   Gtk_Updator::set_interval_callback
	( const ref_count_ptr<Abstruct_Updator::Callback> &  c ,
	  long  interval /* msec */ )
{
	internal_updator.set_interval_callback( c , interval );
}

void   Gtk_Updator::set_fd_callback
	( const ref_count_ptr<Abstruct_Updator::Callback> &  c ,
	  int  fd )
{
	internal_updator.set_fd_callback( c , fd );
}

void   Gtk_Updator::stop_interval()
{
	internal_updator.stop_interval();
}


//
// Internal Updator
//
Gtk_Updator::Internal_Updator::Internal_Updator()
	: callback( static_cast<Abstruct_Updator::Callback *>(0) ) ,
	  stop_flag( true )
{
}

void   Gtk_Updator::Internal_Updator::set_interval_callback
		( const ref_count_ptr<Abstruct_Updator::Callback> &  c ,
		  long  interval  /* msec */ )
{
	callback = c;

	stop_flag = false;

	Gtk::Main::timeout.connect
		( SigC::slot( this ,
			      &Gtk_Updator::Internal_Updator::update ) ,
		  interval );
}

void   Gtk_Updator::Internal_Updator::set_fd_callback
		( const ref_count_ptr<Abstruct_Updator::Callback> &  c ,
		  int  fd )
{
	callback = c;

	stop_flag = false;

	gtk_input_add_full
		( static_cast<gint>(fd) ,
		  static_cast<GdkInputCondition>
		  ( GDK_INPUT_READ | GDK_INPUT_EXCEPTION ) ,
		  &Gtk_Updator::Internal_Updator::static_update_function ,
		  static_cast<GtkCallbackMarshal>(0) ,
		  this ,
		  static_cast<GtkDestroyNotify>(0) );
}

gint   Gtk_Updator::Internal_Updator::update()
{
	if ( callback &&  ! stop_flag )
	{
		callback -> operator() ();
	}

	return( ! stop_flag );
}

// class static
void   Gtk_Updator::Internal_Updator::static_update_function
	( gpointer  data ,  gint ,  GdkInputCondition )
{
	static_cast<Gtk_Updator::Internal_Updator *>( data ) -> update();
}

void   Gtk_Updator::Internal_Updator::stop_interval()
{
	stop_flag = true;
}
