#include  "team_config.h"
#include  "s_basic.h"
#include  <string>
#include  <cstdio>
#include  <cstdlib>
#include  <ctype.h>
#include  <iostream>
#include  <strstream>

using namespace std;

Team_Config::Team_Config()
	: player( MAX_PLAYER ) , have_player_config( false )
{
	this -> clear();
}

Team_Config::~Team_Config()
{
}

void   Team_Config::clear()
{
	have_player_config = false;

	for ( size_t  i = 0  ;  i < player.size()  ;  i ++ )
	{
		player[i].have_name  = false;
		player[i].have_color = false;
	}
}

void   Team_Config::read_config( istream &  input )
{
	for(;;)
	{
		string	line;
		getline( input , line );

		if ( ! input || input.eof() )
		{
			break;
		}

		if ( line.find( '#' ) != string::npos )
		{
			line.resize( line.find( '#' ) );
		}


		if ( line.find_first_not_of( " \t" ) == string::npos )
		{
			continue;
		}


		istrstream	config_line( line.c_str() , line.length() );

		int	number = 0;
		config_line >> number;

		if ( ! config_line
		  || (number < 1 || MAX_PLAYER < number) )
		{
			cerr << "team config: Bad player number." << endl;
			this -> clear();
			return;
		}

		config_line >> ws;

		if ( ! config_line || config_line.eof() )
		{
			cerr << "team config: No configuration for player "
			     << number << "." << endl;
			this -> clear();
			return;
		}


		for(;;)
		{
			string	config_name;
			config_line >> ws >> config_name >> ws;


			bool	have_value = false;
			string	config_value;
			bool	in_quote = false;
			for(;;)
			{
				char	ch;
				config_line.get( ch );

				if ( config_line.eof() )
				{
					break;
					return;
				}

				if ( in_quote )
				{
					if ( ch == '"' )
					{
						in_quote = false;
					}
					else
					{
						have_value = true;
						config_value += ch;
					}
				}
				else
				{
					if ( ch == '"' )
					{
						have_value = true;
						in_quote = true;
					}
					else if ( isspace( ch ) )
					{
						break;
					}
					else
					{
						have_value = true;
						config_value += ch;
					}
				}
			}


			if ( ! have_value )
			{
				cerr << "team config: No value for \""
				     << config_name << "\"." << endl;
				this -> clear();
				return;
			}

			if ( config_name == "name" )
			{
				player[number - 1].have_name = true;
				player[number - 1].name = config_value;
				have_player_config = true;
			}
			else if ( config_name == "color" )
			{
				player[number - 1].have_color = true;
				player[number - 1].color = config_value;
				have_player_config = true;
			}
			else
			{
				cerr << "team config: No such configration \""
				     << config_name << "\"." << endl;
				this -> clear();
				return;
			}

			config_line >> ws;

			if ( config_line.eof() )
			{
				break;
			}
		}
	}
}
