/*
 * Decompiled with CFR 0.152.
 */
package traffic3.manager;

import com.infomatiq.jsi.IntProcedure;
import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.SpatialIndex;
import com.infomatiq.jsi.rtree.RTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import rescuecore2.misc.collections.LazyMap;
import rescuecore2.standard.entities.Area;
import rescuecore2.standard.entities.Blockade;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import traffic3.objects.TrafficAgent;
import traffic3.objects.TrafficArea;
import traffic3.objects.TrafficBlockade;

public class TrafficManager {
    private Map<Integer, TrafficArea> areaByID;
    private Map<Integer, TrafficBlockade> blockadeByID;
    private Map<Area, TrafficArea> areas = new HashMap<Area, TrafficArea>();
    private Map<Blockade, TrafficBlockade> blocks;
    private Map<Human, TrafficAgent> agents;
    private Map<TrafficArea, Collection<TrafficArea>> areaNeighbours;
    private SpatialIndex index;

    public TrafficManager() {
        this.areaByID = new HashMap<Integer, TrafficArea>();
        this.blocks = new HashMap<Blockade, TrafficBlockade>();
        this.blockadeByID = new HashMap<Integer, TrafficBlockade>();
        this.agents = new HashMap<Human, TrafficAgent>();
        this.areaNeighbours = new LazyMap<TrafficArea, Collection<TrafficArea>>(){

            public Collection<TrafficArea> createValue() {
                return new HashSet<TrafficArea>();
            }
        };
        this.index = new RTree();
        this.index.init(new Properties());
    }

    public TrafficArea findArea(double x, double y) {
        final ArrayList found = new ArrayList();
        this.index.intersects(new Rectangle((float)x, (float)y, (float)x, (float)y), new IntProcedure(){

            public boolean execute(int id) {
                found.add(TrafficManager.this.areaByID.get(id));
                return true;
            }
        });
        for (TrafficArea next : found) {
            if (!next.contains(x, y)) continue;
            return next;
        }
        return null;
    }

    public Collection<TrafficArea> getNeighbours(TrafficArea area) {
        return this.areaNeighbours.get(area);
    }

    public Collection<TrafficAgent> getNearbyAgents(TrafficAgent agent) {
        HashSet<TrafficAgent> result = new HashSet<TrafficAgent>();
        result.addAll(agent.getArea().getAgents());
        for (TrafficArea next : this.getNeighbours(agent.getArea())) {
            result.addAll(next.getAgents());
        }
        result.remove(agent);
        return result;
    }

    public void clear() {
        this.areas.clear();
        this.blocks.clear();
        this.agents.clear();
        this.areaNeighbours.clear();
        this.areaByID.clear();
        this.blockadeByID.clear();
        this.index = new RTree();
        this.index.init(new Properties());
    }

    public void register(TrafficArea area) {
        this.areas.put(area.getArea(), area);
        int id = area.getArea().getID().getValue();
        this.areaByID.put(id, area);
        this.index.add(area.getBounds(), id);
    }

    public void register(TrafficAgent agent) {
        this.agents.put(agent.getHuman(), agent);
    }

    public void register(TrafficBlockade block) {
        this.blocks.put(block.getBlockade(), block);
        this.blockadeByID.put(block.getBlockade().getID().getValue(), block);
    }

    public void remove(TrafficBlockade block) {
        this.remove(block.getBlockade());
    }

    public void remove(Blockade block) {
        this.blocks.remove(block);
        this.blockadeByID.remove(block.getID().getValue());
    }

    public Collection<TrafficAgent> getAgents() {
        return Collections.unmodifiableCollection(this.agents.values());
    }

    public Collection<TrafficArea> getAreas() {
        return Collections.unmodifiableCollection(this.areas.values());
    }

    public Collection<TrafficBlockade> getBlockades() {
        return Collections.unmodifiableCollection(this.blocks.values());
    }

    public void cacheInformation(StandardWorldModel world) {
        this.areaNeighbours.clear();
        for (StandardEntity next : world) {
            if (!(next instanceof Area)) continue;
            this.computeNeighbours((Area)next, world);
        }
    }

    public TrafficArea getTrafficArea(Area a) {
        return this.areas.get(a);
    }

    public TrafficBlockade getTrafficBlockade(Blockade b) {
        return this.blocks.get(b);
    }

    public TrafficAgent getTrafficAgent(Human h) {
        return this.agents.get(h);
    }

    private void computeNeighbours(Area a, StandardWorldModel world) {
        Collection<TrafficArea> neighbours = this.areaNeighbours.get(this.getTrafficArea(a));
        neighbours.clear();
        for (EntityID id : a.getNeighbours()) {
            Entity e = world.getEntity(id);
            if (!(e instanceof Area)) continue;
            neighbours.add(this.getTrafficArea((Area)e));
        }
    }
}

