/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.components;

import java.util.Collection;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import rescuecore2.components.Component;
import rescuecore2.config.Config;
import rescuecore2.connection.Connection;
import rescuecore2.connection.ConnectionException;
import rescuecore2.connection.ConnectionListener;
import rescuecore2.log.Logger;
import rescuecore2.messages.Message;
import rescuecore2.messages.control.Shutdown;
import rescuecore2.misc.WorkerThread;
import rescuecore2.registry.Registry;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.WorldModel;

public abstract class AbstractComponent<T extends WorldModel<? extends Entity>>
implements Component {
    private static final int TIMEOUT = 10000;
    protected Connection connection;
    protected Config config;
    protected T model;
    protected Random random;
    private MessageProcessor processor;

    protected AbstractComponent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void postConnect(Connection c, Collection<Entity> entities, Config kernelConfig) {
        this.connection = c;
        this.model = this.createWorldModel();
        this.model.addEntities(entities);
        this.config.merge(kernelConfig);
        this.random = this.config.getRandom();
        String ndc = this.getPreferredNDC();
        if (ndc != null) {
            Logger.pushNDC(ndc);
        }
        try {
            Logger.info(this + " connected");
            this.postConnect();
            this.processor = new MessageProcessor();
            c.addConnectionListener(new MessageListener());
            this.processor.start();
        }
        finally {
            if (ndc != null) {
                Logger.popNDC();
            }
        }
    }

    protected void postConnect() {
    }

    protected abstract T createWorldModel();

    protected final void send(Message msg) {
        try {
            this.connection.sendMessage(msg);
        }
        catch (ConnectionException e) {
            Logger.error("Error sending message", e);
        }
    }

    @Override
    public String getPreferredLogContext() {
        return this.getClass().getName();
    }

    protected String getPreferredNDC() {
        return null;
    }

    @Override
    public void initialise() {
    }

    @Override
    public void shutdown() {
        try {
            this.processor.kill();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public Registry getPreferredRegistry(Registry parent) {
        return parent;
    }

    protected void processMessage(Message msg) {
        Logger.info("Unrecognised message type: " + msg);
    }

    protected boolean processImmediately(Message msg) {
        if (msg instanceof Shutdown) {
            this.shutdown();
            return true;
        }
        return false;
    }

    private class MessageListener
    implements ConnectionListener {
        private MessageListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void messageReceived(Connection c, Message msg) {
            String ndc = AbstractComponent.this.getPreferredNDC();
            if (ndc != null) {
                Logger.pushNDC(ndc);
            }
            try {
                if (!AbstractComponent.this.processImmediately(msg)) {
                    AbstractComponent.this.processor.push(msg);
                }
            }
            finally {
                if (ndc != null) {
                    Logger.popNDC();
                }
            }
        }
    }

    private class MessageProcessor
    extends WorkerThread {
        private BlockingQueue<Message> queue = new LinkedBlockingQueue<Message>();

        MessageProcessor() {
        }

        void push(Message m) {
            this.queue.add(m);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean work() throws InterruptedException {
            String ndc = AbstractComponent.this.getPreferredNDC();
            if (ndc != null) {
                Logger.pushNDC(ndc);
            }
            try {
                Logger.trace("MessageProcessor working: " + this.queue.size() + " messages in the queue");
                Message msg = this.queue.take();
                Logger.trace("Next message: " + msg);
                AbstractComponent.this.processMessage(msg);
                boolean bl = true;
                return bl;
            }
            finally {
                if (ndc != null) {
                    Logger.popNDC();
                }
            }
        }
    }
}

