/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.log;

import java.io.IOException;
import java.io.OutputStream;
import rescuecore2.log.AbstractLogWriter;
import rescuecore2.log.LogException;
import rescuecore2.log.Logger;

public class StreamLogWriter
extends AbstractLogWriter {
    private OutputStream out;

    public StreamLogWriter(OutputStream stream) {
        this.out = stream;
    }

    @Override
    protected void write(byte[] bytes) throws LogException {
        try {
            this.out.write(bytes);
        }
        catch (IOException e) {
            throw new LogException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            Logger.error("Error flushing log stream", e);
        }
        try {
            this.out.close();
        }
        catch (IOException e) {
            Logger.error("Error closing log stream", e);
        }
    }
}

