/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.score;

import rescuecore2.Timestep;
import rescuecore2.score.DelegatingScoreFunction;
import rescuecore2.score.ScoreFunction;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.WorldModel;

public class UnaryOperatorScoreFunction
extends DelegatingScoreFunction {
    private Operator op;

    public UnaryOperatorScoreFunction(String name, Operator op, ScoreFunction child) {
        super(name, child);
        this.op = op;
    }

    @Override
    public double score(WorldModel<? extends Entity> world, Timestep timestep) {
        return this.op.perform(this.child.score(world, timestep));
    }

    public static enum Operator {
        INVERSE{

            @Override
            protected double perform(double in) {
                return 1.0 / in;
            }
        }
        ,
        SQUARE_ROOT{

            @Override
            protected double perform(double in) {
                return Math.sqrt(in);
            }
        };


        protected abstract double perform(double var1);
    }
}

