/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.score;

import java.util.HashMap;
import java.util.Map;
import rescuecore2.Timestep;
import rescuecore2.score.CompositeScoreFunction;
import rescuecore2.score.ScoreFunction;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.WorldModel;

public class WeightedScoreFunction
extends CompositeScoreFunction {
    private Map<ScoreFunction, Double> weights = new HashMap<ScoreFunction, Double>();

    public WeightedScoreFunction(String name) {
        super(name);
    }

    @Override
    public String toString() {
        return "Weighted sum";
    }

    public void addChildFunction(ScoreFunction child, double weight) {
        this.addChildFunction(child);
        this.weights.put(child, weight);
    }

    @Override
    public void removeChildFunction(ScoreFunction child) {
        super.removeChildFunction(child);
        this.weights.remove(child);
    }

    @Override
    public double score(WorldModel<? extends Entity> world, Timestep timestep) {
        double sum = 0.0;
        for (ScoreFunction next : this.children) {
            double weight = this.weights.containsKey(next) ? this.weights.get(next) : 1.0;
            sum += weight * next.score(world, timestep);
        }
        return sum;
    }
}

