/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.worldmodel.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import rescuecore2.misc.EncodingTools;
import rescuecore2.worldmodel.AbstractProperty;
import rescuecore2.worldmodel.Property;

public class BooleanProperty
extends AbstractProperty {
    private boolean value;

    public BooleanProperty(String urn) {
        super(urn);
    }

    public BooleanProperty(Enum<?> urn) {
        super(urn);
    }

    public BooleanProperty(String urn, boolean value) {
        super(urn, true);
        this.value = value;
    }

    public BooleanProperty(Enum<?> urn, boolean value) {
        super(urn, true);
        this.value = value;
    }

    public BooleanProperty(BooleanProperty other) {
        super(other);
        this.value = other.value;
    }

    @Override
    public Boolean getValue() {
        if (!this.isDefined()) {
            return null;
        }
        return this.value;
    }

    public void setValue(boolean value) {
        boolean old = this.value;
        boolean wasDefined = this.isDefined();
        this.value = value;
        this.setDefined();
        if (!wasDefined || old != value) {
            this.fireChange(old, value);
        }
    }

    @Override
    public void takeValue(Property p) {
        if (p instanceof BooleanProperty) {
            BooleanProperty b = (BooleanProperty)p;
            if (b.isDefined()) {
                this.setValue(b.getValue());
            } else {
                this.undefine();
            }
        } else {
            throw new IllegalArgumentException(this + " cannot take value from " + p);
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        EncodingTools.writeInt32(this.value ? 1 : 0, out);
    }

    @Override
    public void read(InputStream in) throws IOException {
        this.setValue(EncodingTools.readInt32(in) != 0);
    }

    @Override
    public BooleanProperty copy() {
        return new BooleanProperty(this);
    }
}

