/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.worldmodel.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import rescuecore2.misc.EncodingTools;
import rescuecore2.worldmodel.AbstractProperty;
import rescuecore2.worldmodel.Property;

public class DoubleProperty
extends AbstractProperty {
    private double value;

    public DoubleProperty(String urn) {
        super(urn);
    }

    public DoubleProperty(Enum<?> urn) {
        super(urn);
    }

    public DoubleProperty(String urn, double value) {
        super(urn, true);
        this.value = value;
    }

    public DoubleProperty(Enum<?> urn, double value) {
        super(urn, true);
        this.value = value;
    }

    public DoubleProperty(DoubleProperty other) {
        super(other);
        this.value = other.value;
    }

    @Override
    public Double getValue() {
        if (!this.isDefined()) {
            return null;
        }
        return this.value;
    }

    public void setValue(double value) {
        double old = this.value;
        boolean wasDefined = this.isDefined();
        this.value = value;
        this.setDefined();
        if (!wasDefined || old != value) {
            this.fireChange(old, value);
        }
    }

    @Override
    public void takeValue(Property p) {
        if (p instanceof DoubleProperty) {
            DoubleProperty d = (DoubleProperty)p;
            if (d.isDefined()) {
                this.setValue(d.getValue());
            } else {
                this.undefine();
            }
        } else {
            throw new IllegalArgumentException(this + " cannot take value from " + p);
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        EncodingTools.writeDouble(this.value, out);
    }

    @Override
    public void read(InputStream in) throws IOException {
        this.setValue(EncodingTools.readDouble(in));
    }

    @Override
    public DoubleProperty copy() {
        return new DoubleProperty(this);
    }
}

