/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.worldmodel.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import rescuecore2.misc.EncodingTools;
import rescuecore2.worldmodel.AbstractProperty;
import rescuecore2.worldmodel.Property;

public class IntProperty
extends AbstractProperty {
    private int value;

    public IntProperty(String urn) {
        super(urn);
    }

    public IntProperty(Enum<?> urn) {
        super(urn);
    }

    public IntProperty(String urn, int value) {
        super(urn, true);
        this.value = value;
    }

    public IntProperty(Enum<?> urn, int value) {
        super(urn, true);
        this.value = value;
    }

    public IntProperty(IntProperty other) {
        super(other);
        this.value = other.value;
    }

    @Override
    public Integer getValue() {
        if (!this.isDefined()) {
            return null;
        }
        return this.value;
    }

    public void setValue(int value) {
        int old = this.value;
        boolean wasDefined = this.isDefined();
        this.value = value;
        this.setDefined();
        if (!wasDefined || old != value) {
            this.fireChange(old, value);
        }
    }

    @Override
    public void takeValue(Property p) {
        if (p instanceof IntProperty) {
            IntProperty i = (IntProperty)p;
            if (i.isDefined()) {
                this.setValue(i.getValue());
            } else {
                this.undefine();
            }
        } else {
            throw new IllegalArgumentException(this + " cannot take value from " + p);
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        EncodingTools.writeInt32(this.value, out);
    }

    @Override
    public void read(InputStream in) throws IOException {
        this.setValue(EncodingTools.readInt32(in));
    }

    @Override
    public IntProperty copy() {
        return new IntProperty(this);
    }
}

