/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import maps.MapTools;
import maps.convert.osm2gml.Constants;
import maps.convert.osm2gml.DirectedEdge;
import maps.convert.osm2gml.Edge;
import maps.convert.osm2gml.TemporaryBuilding;
import maps.convert.osm2gml.TemporaryIntersection;
import maps.convert.osm2gml.TemporaryMap;
import maps.convert.osm2gml.TemporaryObject;
import maps.convert.osm2gml.TemporaryObjectInfo;
import maps.convert.osm2gml.TemporaryRoad;
import maps.gml.GMLBuilding;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLEdge;
import maps.gml.GMLMap;
import maps.gml.GMLNode;
import maps.gml.GMLObject;
import maps.gml.GMLRoad;
import maps.gml.GMLShape;
import maps.gml.GMLSpace;
import maps.gml.debug.GMLEdgeShapeInfo;
import maps.gml.debug.GMLNodeShapeInfo;
import maps.gml.debug.GMLShapeInfo;
import maps.osm.OSMBuilding;
import maps.osm.OSMMap;
import maps.osm.OSMNode;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.misc.geometry.Vector2D;
import rescuecore2.misc.gui.ShapeDebugFrame;

public final class ConvertTools {
    private static final Color BACKGROUND_BUILDING_COLOUR = new Color(0, 255, 0, 32);
    private static final Color BACKGROUND_INTERSECTION_COLOUR = new Color(192, 192, 192, 32);
    private static final Color BACKGROUND_ROAD_COLOUR = new Color(128, 128, 128, 32);
    private static final Color BACKGROUND_SPACE_COLOUR = new Color(0, 128, 0, 32);
    private static final double CLOCKWISE_SUM = -360.0;
    private static final double THRESHOLD = 1.0E-4;

    private ConvertTools() {
    }

    public static double sizeOf1Metre(OSMMap map) {
        return MapTools.sizeOf1Metre(map.getCentreLatitude(), map.getCentreLongitude());
    }

    public static double nearbyThreshold(OSMMap map, double thresholdM) {
        return ConvertTools.sizeOf1Metre(map) * thresholdM;
    }

    public static Line2D gmlEdgeToLine(GMLEdge edge) {
        GMLNode start = edge.getStart();
        GMLNode end = edge.getEnd();
        Point2D origin = new Point2D(start.getX(), start.getY());
        Point2D endPoint = new Point2D(end.getX(), end.getY());
        return new Line2D(origin, endPoint);
    }

    public static Line2D gmlEdgeToLine(GMLEdge edge, GMLNode start) {
        if (!start.equals(edge.getStart()) && !start.equals(edge.getEnd())) {
            throw new IllegalArgumentException("'start' must be one of the endpoints of 'edge'");
        }
        GMLNode end = start.equals(edge.getStart()) ? edge.getEnd() : edge.getStart();
        Point2D origin = new Point2D(start.getX(), start.getY());
        Point2D endPoint = new Point2D(end.getX(), end.getY());
        return new Line2D(origin, endPoint);
    }

    public static Line2D gmlDirectedEdgeToLine(GMLDirectedEdge edge) {
        GMLNode start = edge.getStartNode();
        GMLNode end = edge.getEndNode();
        Point2D origin = new Point2D(start.getX(), start.getY());
        Point2D endPoint = new Point2D(end.getX(), end.getY());
        return new Line2D(origin, endPoint);
    }

    public static Edge findLeftTurn(DirectedEdge from, Set<? extends Edge> candidates) {
        return ConvertTools.findBestTurn(from, candidates, true);
    }

    public static Edge findRightTurn(DirectedEdge from, Set<? extends Edge> candidates) {
        return ConvertTools.findBestTurn(from, candidates, false);
    }

    public static Edge findBestTurn(DirectedEdge from, Set<? extends Edge> candidates, boolean preferLeft) {
        Edge mostRight = null;
        Edge mostLeft = null;
        Edge leastRight = null;
        Edge leastLeft = null;
        double mostRightAngle = 0.0;
        double mostLeftAngle = 0.0;
        double leastRightAngle = 0.0;
        double leastLeftAngle = 0.0;
        Line2D fromLine = from.getLine();
        for (Edge edge : candidates) {
            double angle;
            if (edge.equals(from.getEdge())) continue;
            Line2D nextLine = edge.getLine();
            if (!edge.getStart().equals(from.getEndNode())) {
                nextLine = new Line2D(nextLine.getEndPoint(), nextLine.getOrigin());
            }
            if (GeometryTools2D.isRightTurn((Line2D)fromLine, (Line2D)nextLine)) {
                angle = GeometryTools2D.getRightAngleBetweenLines((Line2D)fromLine, (Line2D)nextLine);
                if (mostRight == null || angle > mostRightAngle) {
                    mostRight = edge;
                    mostRightAngle = angle;
                }
                if (leastRight != null && !(angle < leastRightAngle)) continue;
                leastRight = edge;
                leastRightAngle = angle;
                continue;
            }
            angle = GeometryTools2D.getLeftAngleBetweenLines((Line2D)fromLine, (Line2D)nextLine);
            if (mostLeft == null || angle > mostLeftAngle) {
                mostLeft = edge;
                mostLeftAngle = angle;
            }
            if (leastLeft != null && !(angle < leastLeftAngle)) continue;
            leastLeft = edge;
            leastLeftAngle = angle;
        }
        if (preferLeft) {
            if (mostLeft != null) {
                return mostLeft;
            }
            return leastRight;
        }
        if (mostRight != null) {
            return mostRight;
        }
        return leastLeft;
    }

    public static List<ShapeDebugFrame.ShapeInfo> getAllDebugShapes(GMLMap map) {
        return ConvertTools.createGMLShapeDebug(map.getAllShapes());
    }

    public static List<ShapeDebugFrame.ShapeInfo> getAllDebugShapes(TemporaryMap map) {
        return ConvertTools.createTemporaryObjectDebug(map.getAllObjects());
    }

    public static List<ShapeDebugFrame.ShapeInfo> createGMLShapeDebug(GMLShape ... objects) {
        return ConvertTools.createGMLShapeDebug(Arrays.asList(objects));
    }

    public static List<ShapeDebugFrame.ShapeInfo> createGMLShapeDebug(Collection<? extends GMLShape> objects) {
        ArrayList<ShapeDebugFrame.ShapeInfo> allShapes = new ArrayList<ShapeDebugFrame.ShapeInfo>();
        for (GMLShape gMLShape : objects) {
            Color c = Constants.TRANSPARENT_RED;
            String name = "Unknown";
            if (gMLShape instanceof GMLRoad) {
                c = BACKGROUND_ROAD_COLOUR;
                name = "Roads";
            }
            if (gMLShape instanceof GMLBuilding) {
                c = BACKGROUND_BUILDING_COLOUR;
                name = "Buildings";
            }
            if (gMLShape instanceof GMLSpace) {
                c = BACKGROUND_SPACE_COLOUR;
                name = "Spaces";
            }
            allShapes.add(new GMLShapeInfo(gMLShape, name, Color.BLACK, c));
        }
        return allShapes;
    }

    public static List<ShapeDebugFrame.ShapeInfo> createGMLObjectDebug(GMLObject ... objects) {
        return ConvertTools.createGMLObjectDebug(Arrays.asList(objects));
    }

    public static List<ShapeDebugFrame.ShapeInfo> createGMLObjectDebug(Collection<? extends GMLObject> objects) {
        ArrayList<ShapeDebugFrame.ShapeInfo> allShapes = new ArrayList<ShapeDebugFrame.ShapeInfo>();
        for (GMLObject gMLObject : objects) {
            if (gMLObject instanceof GMLNode) {
                allShapes.add((ShapeDebugFrame.ShapeInfo)new GMLNodeShapeInfo((GMLNode)gMLObject, "Nodes", Constants.BLACK, true));
            }
            if (!(gMLObject instanceof GMLEdge)) continue;
            allShapes.add((ShapeDebugFrame.ShapeInfo)new GMLEdgeShapeInfo((GMLEdge)gMLObject, "Edges", Constants.BLACK, false));
        }
        return allShapes;
    }

    public static List<ShapeDebugFrame.ShapeInfo> createTemporaryObjectDebug(TemporaryObject ... objects) {
        return ConvertTools.createTemporaryObjectDebug(Arrays.asList(objects));
    }

    public static List<ShapeDebugFrame.ShapeInfo> createTemporaryObjectDebug(Collection<? extends TemporaryObject> objects) {
        ArrayList<ShapeDebugFrame.ShapeInfo> allShapes = new ArrayList<ShapeDebugFrame.ShapeInfo>();
        for (TemporaryObject temporaryObject : objects) {
            Color c = Constants.TRANSPARENT_RED;
            String name = "Unknown";
            if (temporaryObject instanceof TemporaryRoad) {
                c = BACKGROUND_ROAD_COLOUR;
                name = "Roads";
            }
            if (temporaryObject instanceof TemporaryBuilding) {
                c = BACKGROUND_BUILDING_COLOUR;
                name = "Buildings";
            }
            if (temporaryObject instanceof TemporaryIntersection) {
                c = BACKGROUND_INTERSECTION_COLOUR;
                name = "Intersections";
            }
            allShapes.add(new TemporaryObjectInfo(temporaryObject, name, Color.BLACK, c));
        }
        return allShapes;
    }

    public static boolean nearlyEqual(double n, double expected, double threshold) {
        return n >= expected - threshold && n <= expected + threshold;
    }

    public static boolean isConvex(List<DirectedEdge> edges) {
        Line2D first;
        Iterator<DirectedEdge> it = edges.iterator();
        Line2D a = first = it.next().getLine();
        Line2D b = it.next().getLine();
        boolean rightTurn = GeometryTools2D.isRightTurn((Line2D)a, (Line2D)b);
        while (it.hasNext()) {
            a = b;
            if (rightTurn == GeometryTools2D.isRightTurn((Line2D)a, (Line2D)(b = it.next().getLine()))) continue;
            return false;
        }
        return rightTurn == GeometryTools2D.isRightTurn((Line2D)b, (Line2D)first);
    }

    public static double getAnglesSum(OSMBuilding building, OSMMap map) {
        double sum = 0.0;
        Iterator<Long> it = building.getNodeIDs().iterator();
        long first = it.next();
        long second = it.next();
        long a = first;
        long b = second;
        while (it.hasNext()) {
            long c = it.next();
            double d = ConvertTools.getAngle(a, b, c, map);
            if (!Double.isNaN(d)) {
                sum += d;
            }
            a = b;
            b = c;
        }
        double d = ConvertTools.getAngle(a, first, second, map);
        if (!Double.isNaN(d)) {
            sum += d;
        }
        return sum;
    }

    public static boolean isClockwise(OSMBuilding building, OSMMap map) {
        return ConvertTools.nearlyEqual(ConvertTools.getAnglesSum(building, map), -360.0, 1.0E-4);
    }

    private static double getAngle(long first, long second, long third, OSMMap map) {
        OSMNode n1 = map.getNode(first);
        OSMNode n2 = map.getNode(second);
        OSMNode n3 = map.getNode(third);
        Vector2D v1 = new Vector2D(n2.getLongitude() - n1.getLongitude(), n2.getLatitude() - n1.getLatitude());
        Vector2D v2 = new Vector2D(n3.getLongitude() - n2.getLongitude(), n3.getLatitude() - n2.getLatitude());
        double d = GeometryTools2D.getAngleBetweenVectors((Vector2D)v1, (Vector2D)v2);
        if (GeometryTools2D.isRightTurn((Vector2D)v1, (Vector2D)v2)) {
            return -d;
        }
        return d;
    }
}

