/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.List;
import maps.convert.osm2gml.OSMShape;
import maps.osm.OSMNode;
import rescuecore2.misc.geometry.Point2D;

public class OSMRoadInfo
implements OSMShape {
    private OSMNode from;
    private OSMNode to;
    private Point2D fromLeft;
    private Point2D toLeft;
    private Point2D fromRight;
    private Point2D toRight;
    private Area area;

    public OSMRoadInfo(OSMNode from, OSMNode to) {
        this.from = from;
        this.to = to;
        this.area = null;
    }

    public OSMNode getFrom() {
        return this.from;
    }

    public OSMNode getTo() {
        return this.to;
    }

    public void setFromLeft(Point2D p) {
        this.fromLeft = p;
        this.area = null;
    }

    public void setFromRight(Point2D p) {
        this.fromRight = p;
        this.area = null;
    }

    public void setToLeft(Point2D p) {
        this.toLeft = p;
        this.area = null;
    }

    public void setToRight(Point2D p) {
        this.toRight = p;
        this.area = null;
    }

    public Point2D getFromLeft() {
        return this.fromLeft;
    }

    public Point2D getFromRight() {
        return this.fromRight;
    }

    public Point2D getToLeft() {
        return this.toLeft;
    }

    public Point2D getToRight() {
        return this.toRight;
    }

    @Override
    public Area getArea() {
        if (this.area == null) {
            if (this.fromLeft == null || this.fromRight == null || this.toLeft == null || this.toRight == null) {
                return null;
            }
            Path2D.Double path = new Path2D.Double();
            path.moveTo(this.fromLeft.getX(), this.fromLeft.getY());
            path.lineTo(this.fromRight.getX(), this.fromRight.getY());
            path.lineTo(this.toRight.getX(), this.toRight.getY());
            path.lineTo(this.toLeft.getX(), this.toLeft.getY());
            path.closePath();
            this.area = new Area(path.createTransformedShape(null));
        }
        return this.area;
    }

    @Override
    public List<Point2D> getVertices() {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        result.add(this.fromLeft);
        result.add(this.fromRight);
        result.add(this.toRight);
        result.add(this.toLeft);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("RoadInfo [");
        result.append(this.fromLeft);
        result.append(", ");
        result.append(this.fromRight);
        result.append(", ");
        result.append(this.toRight);
        result.append(", ");
        result.append(this.toLeft);
        result.append("]");
        return result.toString();
    }
}

