/*
 * Decompiled with CFR 0.152.
 */
package maps.gml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import maps.gml.GMLCoordinates;
import maps.gml.GMLNode;
import maps.gml.GMLObject;

public class GMLEdge
extends GMLObject {
    private GMLNode start;
    private GMLNode end;
    private boolean passable;
    private List<GMLCoordinates> points;

    public GMLEdge(int id, GMLNode start, GMLNode end, boolean passable) {
        super(id);
        this.start = start;
        this.end = end;
        this.passable = passable;
        this.points = new ArrayList<GMLCoordinates>();
        this.points.add(start.getCoordinates());
        this.points.add(end.getCoordinates());
    }

    public List<GMLCoordinates> getPoints() {
        return Collections.unmodifiableList(this.points);
    }

    public void setPoints(List<GMLCoordinates> newPoints) {
        this.points.clear();
        this.points.addAll(newPoints);
    }

    public GMLNode getStart() {
        return this.start;
    }

    public void setStart(GMLNode s) {
        this.start = s;
    }

    public GMLNode getEnd() {
        return this.end;
    }

    public void setEnd(GMLNode e) {
        this.end = e;
    }

    public boolean isPassable() {
        return this.passable;
    }

    public void setPassable(boolean b) {
        this.passable = b;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("GMLEdge ");
        result.append(this.getID());
        result.append(" from ");
        result.append(this.start);
        result.append(" to ");
        result.append(this.end);
        if (!this.passable) {
            result.append(" (impassable)");
        }
        return result.toString();
    }
}

