/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLCoordinates;
import maps.gml.GMLEdge;
import maps.gml.GMLNode;
import maps.gml.editor.AbstractTool;
import maps.gml.editor.GMLEditor;
import maps.gml.view.LineOverlay;
import maps.gml.view.NodeDecorator;
import maps.gml.view.SquareNodeDecorator;
import rescuecore2.misc.geometry.Point2D;

public class CreateEdgeTool
extends AbstractTool {
    private static final Color HIGHLIGHT_COLOUR = Color.BLUE;
    private static final int HIGHLIGHT_SIZE = 6;
    private Listener listener = new Listener();
    private NodeDecorator nodeHighlight = new SquareNodeDecorator(HIGHLIGHT_COLOUR, 6);
    private LineOverlay overlay = new LineOverlay(HIGHLIGHT_COLOUR, true);
    private GMLNode hover;
    private GMLNode start;
    private GMLNode end;

    public CreateEdgeTool(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Create edge";
    }

    @Override
    public void activate() {
        this.editor.getViewer().addMouseListener(this.listener);
        this.editor.getViewer().addMouseMotionListener(this.listener);
        this.editor.getViewer().addOverlay(this.overlay);
        this.hover = null;
        this.start = null;
        this.end = null;
    }

    @Override
    public void deactivate() {
        this.editor.getViewer().removeMouseListener(this.listener);
        this.editor.getViewer().removeMouseMotionListener(this.listener);
        this.editor.getViewer().clearAllNodeDecorators();
        this.editor.getViewer().removeOverlay(this.overlay);
        this.editor.getViewer().repaint();
    }

    private void setHover(GMLNode node) {
        if (this.hover == node) {
            return;
        }
        if (this.hover != null) {
            this.editor.getViewer().clearNodeDecorator(this.hover);
        }
        this.hover = node;
        if (this.hover != null) {
            this.editor.getViewer().setNodeDecorator(this.nodeHighlight, this.hover);
        }
        this.editor.getViewer().repaint();
    }

    private void setStart(GMLNode node) {
        if (this.start == node) {
            return;
        }
        if (this.start != null) {
            this.editor.getViewer().clearNodeDecorator(this.start);
        }
        this.start = node;
        if (this.start != null) {
            this.editor.getViewer().setNodeDecorator(this.nodeHighlight, this.start);
        }
        this.editor.getViewer().repaint();
    }

    private void setEnd(GMLNode node) {
        if (this.start == node || this.end == node) {
            return;
        }
        if (this.end != null) {
            this.editor.getViewer().clearNodeDecorator(this.end);
        }
        this.end = node;
        if (this.end != null) {
            this.editor.getViewer().setNodeDecorator(this.nodeHighlight, this.end);
        }
        this.editor.getViewer().repaint();
    }

    private class CreateEdgeEdit
    extends AbstractUndoableEdit {
        private GMLEdge edge;

        public CreateEdgeEdit(GMLEdge edge) {
            this.edge = edge;
        }

        @Override
        public void undo() {
            super.undo();
            CreateEdgeTool.this.editor.getMap().removeEdge(this.edge);
            CreateEdgeTool.this.editor.getViewer().repaint();
        }

        @Override
        public void redo() {
            super.redo();
            CreateEdgeTool.this.editor.getMap().addEdge(this.edge);
            CreateEdgeTool.this.editor.getViewer().repaint();
        }
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                Point p = this.fixEventPoint(e.getPoint());
                GMLCoordinates c = CreateEdgeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
                GMLNode node = CreateEdgeTool.this.editor.getMap().findNearestNode(c.getX(), c.getY());
                CreateEdgeTool.this.overlay.setStart(new Point2D(node.getX(), node.getY()));
                CreateEdgeTool.this.setStart(node);
                CreateEdgeTool.this.setHover(null);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1 && CreateEdgeTool.this.start != null && CreateEdgeTool.this.end != null) {
                GMLEdge edge = CreateEdgeTool.this.editor.getMap().createEdge(CreateEdgeTool.this.start, CreateEdgeTool.this.end);
                CreateEdgeTool.this.editor.setChanged();
                CreateEdgeTool.this.editor.addEdit(new CreateEdgeEdit(edge));
                CreateEdgeTool.this.editor.getViewer().clearAllNodeDecorators();
                CreateEdgeTool.this.overlay.setStart(null);
                CreateEdgeTool.this.overlay.setEnd(null);
                CreateEdgeTool.this.editor.getViewer().repaint();
                CreateEdgeTool.this.start = null;
                CreateEdgeTool.this.end = null;
                CreateEdgeTool.this.hover = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (CreateEdgeTool.this.start != null) {
                Point p = this.fixEventPoint(e.getPoint());
                GMLCoordinates c = CreateEdgeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
                GMLNode node = CreateEdgeTool.this.editor.getMap().findNearestNode(c.getX(), c.getY());
                CreateEdgeTool.this.overlay.setEnd(new Point2D(node.getX(), node.getY()));
                CreateEdgeTool.this.setEnd(node);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = this.fixEventPoint(e.getPoint());
            GMLCoordinates c = CreateEdgeTool.this.editor.snap(CreateEdgeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y));
            GMLNode node = CreateEdgeTool.this.editor.getMap().findNearestNode(c.getX(), c.getY());
            CreateEdgeTool.this.setHover(node);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private Point fixEventPoint(Point p) {
            Insets insets = CreateEdgeTool.this.editor.getViewer().getInsets();
            return new Point(p.x - insets.left, p.y - insets.top);
        }
    }
}

