/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.util.HashSet;
import maps.gml.GMLEdge;
import maps.gml.GMLMap;
import maps.gml.GMLObject;
import maps.gml.GMLShape;
import maps.gml.editor.GMLEditor;
import maps.gml.editor.ProgressFunction;

public class FixAttachedObjectsFunction
extends ProgressFunction {
    public FixAttachedObjectsFunction(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Fix attached objects";
    }

    @Override
    protected String getTitle() {
        return "Fixing attached objects";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeImpl() {
        GMLMap gMLMap;
        HashSet<GMLShape> shapes = new HashSet<GMLShape>();
        HashSet<GMLEdge> edges = new HashSet<GMLEdge>();
        GMLMap gMLMap2 = this.editor.getMap();
        synchronized (gMLMap2) {
            shapes.addAll(this.editor.getMap().getAllShapes());
            edges.addAll(this.editor.getMap().getEdges());
        }
        this.setProgressLimit(shapes.size() + edges.size());
        gMLMap2 = this.editor.getMap();
        synchronized (gMLMap2) {
            this.editor.getMap().removeAllEdges();
        }
        for (GMLEdge gMLEdge : edges) {
            gMLMap = this.editor.getMap();
            synchronized (gMLMap) {
                this.editor.getMap().add((GMLObject)gMLEdge);
            }
            this.bumpProgress();
        }
        for (GMLShape gMLShape : shapes) {
            gMLMap = this.editor.getMap();
            synchronized (gMLMap) {
                this.editor.getMap().add((GMLObject)gMLShape);
            }
            this.bumpProgress();
        }
        this.editor.setChanged();
        this.editor.getViewer().repaint();
    }
}

