/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import maps.gml.editor.AbstractFunction;
import maps.gml.editor.GMLEditor;
import rescuecore2.log.Logger;

public abstract class ProgressFunction
extends AbstractFunction {
    private JProgressBar progress = new JProgressBar();

    protected ProgressFunction(GMLEditor editor) {
        super(editor);
        this.progress.setStringPainted(true);
    }

    @Override
    public void execute() {
        final JDialog dialog = new JDialog((Window)this.editor.getViewer().getTopLevelAncestor(), this.getTitle(), Dialog.ModalityType.APPLICATION_MODAL);
        dialog.getContentPane().add((Component)this.progress, "Center");
        dialog.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressFunction.this.progress.setValue(0);
                ProgressFunction.this.progress.setIndeterminate(true);
            }
        });
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ProgressFunction.this.executeImpl();
                }
                catch (RuntimeException e) {
                    Logger.error((String)("Error running " + this), (Throwable)e);
                }
                dialog.setVisible(false);
                dialog.dispose();
            }
        };
        t.start();
        dialog.setVisible(true);
    }

    protected abstract void executeImpl();

    protected abstract String getTitle();

    protected void setProgress(final int amount) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressFunction.this.progress.setValue(amount);
                ProgressFunction.this.progress.setString(ProgressFunction.this.progress.getValue() + " / " + ProgressFunction.this.progress.getMaximum());
            }
        });
    }

    protected void bumpProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressFunction.this.progress.setValue(ProgressFunction.this.progress.getValue() + 1);
                ProgressFunction.this.progress.setString(ProgressFunction.this.progress.getValue() + " / " + ProgressFunction.this.progress.getMaximum());
            }
        });
    }

    protected void bumpMaxProgress() {
        this.bumpMaxProgress(1);
    }

    protected void bumpMaxProgress(final int amount) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressFunction.this.progress.setMaximum(ProgressFunction.this.progress.getMaximum() + amount);
                ProgressFunction.this.progress.setString(ProgressFunction.this.progress.getValue() + " / " + ProgressFunction.this.progress.getMaximum());
            }
        });
    }

    protected void setProgressLimit(final int max) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressFunction.this.progress.setIndeterminate(false);
                ProgressFunction.this.progress.setMaximum(max);
                ProgressFunction.this.progress.setString(ProgressFunction.this.progress.getValue() + " / " + ProgressFunction.this.progress.getMaximum());
            }
        });
    }

    protected void setProgressString(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressFunction.this.progress.setString(s);
            }
        });
    }
}

