/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.util.Collection;
import java.util.HashSet;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLNode;
import maps.gml.editor.AbstractFunction;
import maps.gml.editor.GMLEditor;
import rescuecore2.log.Logger;

public class PruneOrphanNodesFunction
extends AbstractFunction {
    public PruneOrphanNodesFunction(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Prune orphaned nodes";
    }

    @Override
    public void execute() {
        HashSet<GMLNode> remaining = new HashSet<GMLNode>(this.editor.getMap().getNodes());
        HashSet<GMLNode> deleted = new HashSet<GMLNode>();
        for (GMLNode next : remaining) {
            if (!this.editor.getMap().getAttachedEdges(next).isEmpty()) continue;
            this.editor.getMap().removeNode(next);
            deleted.add(next);
        }
        if (!deleted.isEmpty()) {
            this.editor.setChanged();
            this.editor.getViewer().repaint();
        }
        Logger.debug((String)("Removed " + deleted.size() + " nodes"));
        this.editor.addEdit(new DeleteNodesEdit(deleted));
    }

    private class DeleteNodesEdit
    extends AbstractUndoableEdit {
        private Collection<GMLNode> nodes;

        public DeleteNodesEdit(Collection<GMLNode> nodes) {
            this.nodes = nodes;
        }

        @Override
        public void undo() {
            super.undo();
            PruneOrphanNodesFunction.this.editor.getMap().add(this.nodes);
            PruneOrphanNodesFunction.this.editor.getViewer().repaint();
        }

        @Override
        public void redo() {
            super.redo();
            PruneOrphanNodesFunction.this.editor.getMap().remove(this.nodes);
            PruneOrphanNodesFunction.this.editor.getViewer().repaint();
        }
    }
}

