/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.view;

import java.awt.Color;
import java.awt.Graphics2D;
import maps.gml.view.Overlay;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.misc.gui.ScreenTransform;

public class LineOverlay
implements Overlay {
    private Point2D start;
    private Point2D end;
    private Color colour;
    private boolean useWorldCoords;

    public LineOverlay(Color colour, boolean useWorldCoords) {
        this(null, null, colour, useWorldCoords);
    }

    public LineOverlay(Point2D start, Point2D end, Color colour, boolean useWorldCoords) {
        this.start = start;
        this.end = end;
        this.colour = colour;
        this.useWorldCoords = useWorldCoords;
    }

    public void setStart(Point2D p) {
        this.start = p;
    }

    public void setEnd(Point2D p) {
        this.end = p;
    }

    public void setColour(Color c) {
        this.colour = c;
    }

    public void setUseWorldCoordinates(boolean b) {
        this.useWorldCoords = b;
    }

    @Override
    public void render(Graphics2D g, ScreenTransform transform) {
        if (this.start == null || this.end == null) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setColor(this.colour);
        double x1 = this.start.getX();
        double x2 = this.end.getX();
        double y1 = this.start.getY();
        double y2 = this.end.getY();
        if (this.useWorldCoords) {
            x1 = transform.xToScreen(x1);
            x2 = transform.xToScreen(x2);
            y1 = transform.yToScreen(y1);
            y2 = transform.yToScreen(y2);
        }
        graphics.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
    }
}

