/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.prep;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedLineString;
import com.vividsolutions.jts.geom.util.ComponentCoordinateExtracter;
import com.vividsolutions.jts.noding.SegmentStringUtil;
import java.util.Iterator;
import java.util.List;

public class PreparedLineStringIntersects {
    protected PreparedLineString prepLine;

    public static boolean intersects(PreparedLineString prep, Geometry geom) {
        PreparedLineStringIntersects op = new PreparedLineStringIntersects(prep);
        return op.intersects(geom);
    }

    public PreparedLineStringIntersects(PreparedLineString prepLine) {
        this.prepLine = prepLine;
    }

    public boolean intersects(Geometry geom) {
        List lineSegStr = SegmentStringUtil.extractSegmentStrings(geom);
        boolean segsIntersect = this.prepLine.getIntersectionFinder().intersects(lineSegStr);
        if (segsIntersect) {
            return true;
        }
        if (geom.getDimension() == 1) {
            return false;
        }
        if (geom.getDimension() == 2 && this.prepLine.isAnyTargetComponentInTest(geom)) {
            return true;
        }
        if (geom.getDimension() == 0) {
            return this.isAnyTestPointInTarget(geom);
        }
        return false;
    }

    protected boolean isAnyTestPointInTarget(Geometry testGeom) {
        PointLocator locator = new PointLocator();
        List coords = ComponentCoordinateExtracter.getCoordinates(testGeom);
        Iterator i = coords.iterator();
        while (i.hasNext()) {
            Coordinate p = (Coordinate)i.next();
            if (!locator.intersects(p, this.prepLine.getGeometry())) continue;
            return true;
        }
        return false;
    }
}

