/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class IndexedNestedRingTester {
    private GeometryGraph graph;
    private List rings = new ArrayList();
    private Envelope totalEnv = new Envelope();
    private SpatialIndex index;
    private Coordinate nestedPt;

    public IndexedNestedRingTester(GeometryGraph graph) {
        this.graph = graph;
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public void add(LinearRing ring) {
        this.rings.add(ring);
        this.totalEnv.expandToInclude(ring.getEnvelopeInternal());
    }

    public boolean isNonNested() {
        this.buildIndex();
        for (int i = 0; i < this.rings.size(); ++i) {
            LinearRing innerRing = (LinearRing)this.rings.get(i);
            Coordinate[] innerRingPts = innerRing.getCoordinates();
            List results = this.index.query(innerRing.getEnvelopeInternal());
            for (int j = 0; j < results.size(); ++j) {
                LinearRing searchRing = (LinearRing)results.get(j);
                Coordinate[] searchRingPts = searchRing.getCoordinates();
                if (innerRing == searchRing || !innerRing.getEnvelopeInternal().intersects(searchRing.getEnvelopeInternal())) continue;
                Coordinate innerRingPt = IsValidOp.findPtNotNode(innerRingPts, searchRing, this.graph);
                Assert.isTrue(innerRingPt != null, "Unable to find a ring point not a node of the search ring");
                boolean isInside = CGAlgorithms.isPointInRing(innerRingPt, searchRingPts);
                if (!isInside) continue;
                this.nestedPt = innerRingPt;
                return false;
            }
        }
        return true;
    }

    private void buildIndex() {
        this.index = new STRtree();
        for (int i = 0; i < this.rings.size(); ++i) {
            LinearRing ring = (LinearRing)this.rings.get(i);
            Envelope env = ring.getEnvelopeInternal();
            this.index.insert(env, ring);
        }
    }
}

