/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.components;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import rescuecore2.components.AbstractAgent;
import rescuecore2.messages.Message;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.Refuge;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.standard.messages.AKClear;
import rescuecore2.standard.messages.AKExtinguish;
import rescuecore2.standard.messages.AKLoad;
import rescuecore2.standard.messages.AKMove;
import rescuecore2.standard.messages.AKRescue;
import rescuecore2.standard.messages.AKRest;
import rescuecore2.standard.messages.AKSay;
import rescuecore2.standard.messages.AKSpeak;
import rescuecore2.standard.messages.AKSubscribe;
import rescuecore2.standard.messages.AKTell;
import rescuecore2.standard.messages.AKUnload;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.WorldModel;

public abstract class StandardAgent<E extends StandardEntity>
extends AbstractAgent<StandardWorldModel, E> {
    public final String[] getRequestedEntityURNs() {
        EnumSet<StandardEntityURN> set = this.getRequestedEntityURNsEnum();
        String[] result = new String[set.size()];
        int i = 0;
        for (StandardEntityURN next : set) {
            result[i++] = next.toString();
        }
        return result;
    }

    protected abstract EnumSet<StandardEntityURN> getRequestedEntityURNsEnum();

    protected StandardWorldModel createWorldModel() {
        return new StandardWorldModel();
    }

    protected void postConnect() {
        super.postConnect();
        if (this.shouldIndex()) {
            ((StandardWorldModel)this.model).index();
        }
    }

    protected void sendRest(int time) {
        this.send((Message)new AKRest(this.getID(), time));
    }

    protected void sendMove(int time, List<EntityID> path) {
        this.send((Message)new AKMove(this.getID(), time, path));
    }

    protected void sendMove(int time, List<EntityID> path, int destX, int destY) {
        this.send((Message)new AKMove(this.getID(), time, path, destX, destY));
    }

    protected void sendExtinguish(int time, EntityID target, int water) {
        this.send((Message)new AKExtinguish(this.getID(), time, target, water));
    }

    protected void sendClear(int time, EntityID target) {
        this.send((Message)new AKClear(this.getID(), time, target));
    }

    protected void sendRescue(int time, EntityID target) {
        this.send((Message)new AKRescue(this.getID(), time, target));
    }

    protected void sendLoad(int time, EntityID target) {
        this.send((Message)new AKLoad(this.getID(), time, target));
    }

    protected void sendUnload(int time) {
        this.send((Message)new AKUnload(this.getID(), time));
    }

    protected void sendSpeak(int time, int channel, byte[] data) {
        this.send((Message)new AKSpeak(this.getID(), time, channel, data));
    }

    protected void sendSubscribe(int time, int ... channels) {
        this.send((Message)new AKSubscribe(this.getID(), time, channels));
    }

    protected void sendSay(int time, byte[] data) {
        this.send((Message)new AKSay(this.getID(), time, data));
    }

    protected void sendTell(int time, byte[] data) {
        this.send((Message)new AKTell(this.getID(), time, data));
    }

    protected List<Refuge> getRefuges() {
        ArrayList<Refuge> result = new ArrayList<Refuge>();
        for (StandardEntity next : ((StandardWorldModel)this.model).getEntitiesOfType(StandardEntityURN.REFUGE)) {
            if (!(next instanceof Refuge)) continue;
            result.add((Refuge)next);
        }
        return result;
    }

    protected StandardEntity location() {
        StandardEntity me = (StandardEntity)this.me();
        if (me instanceof Human) {
            return ((Human)me).getPosition((WorldModel<? extends StandardEntity>)this.model);
        }
        return me;
    }

    protected boolean shouldIndex() {
        return true;
    }
}

