/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.kernel;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kernel.CommandFilter;
import kernel.KernelState;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.standard.messages.AKClear;
import rescuecore2.standard.messages.AKExtinguish;
import rescuecore2.standard.messages.AKLoad;
import rescuecore2.standard.messages.AKMove;
import rescuecore2.standard.messages.AKRescue;
import rescuecore2.standard.messages.AKRest;
import rescuecore2.standard.messages.AKUnload;
import rescuecore2.worldmodel.EntityID;

public class SingleCommandFilter
implements CommandFilter {
    public void initialise(Config config) {
    }

    public void filter(Collection<Command> commands, KernelState state) {
        HashSet<EntityID> sent = new HashSet<EntityID>();
        Iterator<Command> it = commands.iterator();
        while (it.hasNext()) {
            Command c = it.next();
            if (!this.filterable(c)) continue;
            EntityID sender = c.getAgentID();
            if (sent.contains(sender)) {
                it.remove();
                Logger.info((String)("Ignoring command " + c + ": Agent " + sender + " already sent a command"));
                continue;
            }
            sent.add(sender);
            Logger.debug((String)(sender + " sent command " + c));
        }
    }

    private boolean filterable(Command c) {
        return c instanceof AKRest || c instanceof AKMove || c instanceof AKLoad || c instanceof AKUnload || c instanceof AKRescue || c instanceof AKClear || c instanceof AKExtinguish;
    }
}

