/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import rescuecore2.misc.gui.ScreenTransform;
import rescuecore2.standard.entities.Area;
import rescuecore2.standard.entities.Edge;
import rescuecore2.standard.view.StandardEntityViewLayer;
import rescuecore2.worldmodel.EntityID;

public class AreaNeighboursLayer
extends StandardEntityViewLayer<Area> {
    private static final Color NEIGHBOUR_COLOUR = Color.blue;
    private static final Stroke NEIGHBOUR_STROKE = new BasicStroke(1.0f, 0, 0);

    public AreaNeighboursLayer() {
        super(Area.class);
    }

    public String getName() {
        return "Neighbours";
    }

    @Override
    public Shape render(Area area, Graphics2D g, ScreenTransform t) {
        g.setColor(NEIGHBOUR_COLOUR);
        g.setStroke(NEIGHBOUR_STROKE);
        for (Edge edge : area.getEdges()) {
            Area a;
            EntityID neighbour = edge.getNeighbour();
            if (neighbour == null || (a = (Area)this.world.getEntity(neighbour)) == null) continue;
            g.drawLine(t.xToScreen((double)area.getX()), t.yToScreen((double)area.getY()), t.xToScreen((double)a.getX()), t.yToScreen((double)a.getY()));
        }
        return null;
    }
}

