/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.commands;

import java.util.ArrayList;
import rescuecore.InputBuffer;
import rescuecore.OutputBuffer;
import rescuecore.commands.AgentCommand;
import rescuecore.commands.Nozzle;

public class AKExtinguish
extends AgentCommand {
    private Nozzle[] nozzles;

    public AKExtinguish(int senderID, int time, int targetID, int direction, int x, int y, int water) {
        super(134, senderID, time);
        this.nozzles = new Nozzle[1];
        this.nozzles[0] = new Nozzle(targetID, direction, x, y, water);
    }

    public AKExtinguish(int senderID, int time, Nozzle[] nozzles) {
        super(134, senderID, time);
        this.nozzles = nozzles;
    }

    public AKExtinguish(InputBuffer in) {
        super(134, 0, 0);
        this.read(in);
    }

    @Override
    public void read(InputBuffer in) {
        super.read(in);
        ArrayList<Nozzle> allNozzles = new ArrayList<Nozzle>();
        int target = 0;
        do {
            if ((target = in.readInt()) == 0) continue;
            allNozzles.add(new Nozzle(target, in.readInt(), in.readInt(), in.readInt(), in.readInt()));
        } while (target != 0);
        this.nozzles = new Nozzle[allNozzles.size()];
        allNozzles.toArray(this.nozzles);
    }

    @Override
    public void write(OutputBuffer out) {
        super.write(out);
        for (int i = 0; i < this.nozzles.length; ++i) {
            out.writeInt(this.nozzles[i].getTarget());
            out.writeInt(this.nozzles[i].getDirection());
            out.writeInt(this.nozzles[i].getX());
            out.writeInt(this.nozzles[i].getY());
            out.writeInt(this.nozzles[i].getWater());
        }
        out.writeInt(0);
    }

    public Nozzle[] getNozzles() {
        return this.nozzles;
    }
}

