/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.objects;

import rescuecore.IntProperty;
import rescuecore.Property;
import rescuecore.objects.MotionlessObject;

public abstract class Edge
extends MotionlessObject {
    protected IntProperty head;
    protected IntProperty tail;
    protected IntProperty length;

    protected Edge() {
        this.head = new IntProperty(6);
        this.tail = new IntProperty(7);
        this.length = new IntProperty(8);
    }

    protected Edge(int head, int tail, int length) {
        this.head = new IntProperty(6, head);
        this.tail = new IntProperty(7, tail);
        this.length = new IntProperty(8, length);
    }

    @Override
    public Property getProperty(int property) {
        switch (property) {
            case 6: {
                return this.head;
            }
            case 7: {
                return this.tail;
            }
            case 8: {
                return this.length;
            }
        }
        return super.getProperty(property);
    }

    public int getHead() {
        return this.head.getValue();
    }

    public boolean setHead(int h, int timestamp, Object source) {
        if (this.head.updateValue(h, timestamp, source)) {
            this.firePropertyChanged(6, timestamp, source);
            return true;
        }
        return false;
    }

    public int getTail() {
        return this.tail.getValue();
    }

    public boolean setTail(int t, int timestamp, Object source) {
        if (this.tail.updateValue(t, timestamp, source)) {
            this.firePropertyChanged(7, timestamp, source);
            return true;
        }
        return false;
    }

    public int getLength() {
        return this.length.getValue();
    }

    public boolean setLength(int l, int timestamp, Object source) {
        if (this.length.updateValue(l, timestamp, source)) {
            this.firePropertyChanged(8, timestamp, source);
            return true;
        }
        return false;
    }
}

