/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.simulationrunner;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import rescuecore.tools.simulationrunner.RescueProcess;
import rescuecore.tools.simulationrunner.Session;
import rescuecore.tools.simulationrunner.SimulationConstants;

public class RunSession
implements SimulationConstants {
    private static final String DEFAULT_SESSION_FILE = "session.xml";
    private static final String DEFAULT_TEAM_DIRECTORY = "teams";
    private static final String DEFAULT_CLIENTS_FILE = "clients.txt";

    public static void main(String[] args) {
        String sessionFile = DEFAULT_SESSION_FILE;
        String teamDir = DEFAULT_TEAM_DIRECTORY;
        String clientsFile = DEFAULT_CLIENTS_FILE;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-s") || args[i].equalsIgnoreCase("--session")) {
                sessionFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-t") || args[i].equalsIgnoreCase("--teams")) {
                teamDir = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-c") || args[i].equalsIgnoreCase("--clients")) {
                clientsFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("--help")) {
                RunSession.printHelp();
                return;
            }
            System.err.println("Unrecognised option: " + args[i]);
            RunSession.printHelp();
            return;
        }
        try {
            int i;
            ClientInfo[] clients = RunSession.loadClients(clientsFile);
            if (clients == null) {
                return;
            }
            TeamInfo[] teams = RunSession.loadTeams(teamDir);
            if (teams == null) {
                return;
            }
            Session session = new Session(sessionFile);
            System.out.println("Clients");
            System.out.println("*******");
            for (i = 0; i < clients.length; ++i) {
                System.out.println(clients[i]);
            }
            System.out.println();
            System.out.println("Teams");
            System.out.println("*****");
            for (i = 0; i < teams.length; ++i) {
                int j;
                System.out.println("Team " + (i + 1));
                System.out.println("\tCommands");
                System.out.println("\t========");
                for (j = 0; j < teams[i].commands.length; ++j) {
                    System.out.println("\t" + teams[i].commands[j]);
                }
                System.out.println();
                System.out.println("\tFiles");
                System.out.println("\t========");
                for (j = 0; j < teams[i].files.length; ++j) {
                    System.out.println("\t" + teams[i].files[j]);
                }
                System.out.println();
            }
            System.out.println("Session");
            System.out.println("*******");
            System.out.println("Name: " + session.getName());
            System.out.println("Config: " + session.getConfigFile());
            System.out.println("Gis: " + session.getGisFile());
            System.out.println("Roads: " + session.getRoadFile());
            System.out.println("Nodes: " + session.getNodeFile());
            System.out.println("Buildings: " + session.getBuildingFile());
            System.out.println("Galpolydata: " + session.getGalFile());
            System.out.println("Shindopolydata: " + session.getShindoFile());
            RescueProcess[] allProcesses = session.getProcesses();
            for (int i2 = 0; i2 < allProcesses.length; ++i2) {
                System.out.println("Process " + i2 + ": " + allProcesses[i2]);
            }
            RunSession.run(clients, teams, session);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void run(ClientInfo[] clients, TeamInfo[] teams, Session session) throws IOException {
        RunSession.sendSimulatorData(clients, session);
        for (int i = 0; i < teams.length; ++i) {
            RunSession.run(clients, teams[i], session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sendSimulatorData(ClientInfo[] clients, Session session) throws IOException {
        for (int i = 0; i < clients.length; ++i) {
            if (!clients[i].isSimulation) continue;
            Socket s = null;
            DataOutputStream out = null;
            FilterInputStream in = null;
            try {
                s = new Socket(clients[i].address, clients[i].port);
                out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
                in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
                if (!RunSession.sendFile("config.txt", session.getConfigFile(), out, (DataInputStream)in)) {
                    boolean bl = false;
                    return bl;
                }
                if (!RunSession.sendFile("road.bin", session.getRoadFile(), out, (DataInputStream)in)) {
                    boolean bl = false;
                    return bl;
                }
                if (!RunSession.sendFile("node.bin", session.getNodeFile(), out, (DataInputStream)in)) {
                    boolean bl = false;
                    return bl;
                }
                if (!RunSession.sendFile("building.bin", session.getBuildingFile(), out, (DataInputStream)in)) {
                    boolean bl = false;
                    return bl;
                }
                if (!RunSession.sendFile("galpolydata.dat", session.getGalFile(), out, (DataInputStream)in)) {
                    boolean bl = false;
                    return bl;
                }
                if (!RunSession.sendFile("shindopolydata.dat", session.getShindoFile(), out, (DataInputStream)in)) {
                    boolean bl = false;
                    return bl;
                }
                if (RunSession.sendFile("gisini.txt", session.getGisFile(), out, (DataInputStream)in)) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.writeInt(3);
                        out.flush();
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean run(ClientInfo[] clients, TeamInfo team, Session session) throws IOException {
        int i;
        int numClients = 0;
        for (int i2 = 0; i2 < clients.length; ++i2) {
            if (clients[i2].isSimulation) continue;
            ++numClients;
            Socket s = null;
            DataOutputStream out = null;
            FilterInputStream in = null;
            try {
                s = new Socket(clients[i2].address, clients[i2].port);
                out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
                in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
                for (int j = 0; j < team.files.length; ++j) {
                    File file = new File(team.files[j]);
                    if (RunSession.sendFile(file.getName(), file, out, (DataInputStream)in)) continue;
                    boolean bl = false;
                    return bl;
                }
                continue;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.writeInt(3);
                        out.flush();
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        int processesPerClient = (int)Math.ceil((double)team.commands.length / (double)numClients);
        String[][] processes = new String[numClients][processesPerClient];
        int nextClient = 0;
        int nextIndex = 0;
        for (i = 0; i < team.commands.length; ++i) {
            processes[nextClient++][nextIndex] = team.commands[i];
            if (nextClient < numClients) continue;
            nextClient = 0;
            ++nextIndex;
        }
        nextClient = 0;
        i = 0;
        while (i < clients.length) {
            if (!clients[i].isSimulation) {
                RunSession.sendProcesses(clients[i], processes[nextClient++]);
            }
            ++i;
        }
        return true;
    }

    private static boolean sendFile(String name, String filename, DataOutputStream out, DataInputStream in) throws IOException {
        return RunSession.sendFile(name, new File(filename), out, in);
    }

    private static boolean sendFile(String name, File file, DataOutputStream out, DataInputStream in) throws IOException {
        long size = file.length();
        DataInputStream data = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        return RunSession.sendFile(name, data, size, out, in);
    }

    private static boolean sendFile(String name, DataInputStream file, long size, DataOutputStream out, DataInputStream in) throws IOException {
        out.writeInt(2);
        out.writeUTF(name);
        out.writeLong(size);
        byte[] buffer = new byte[1024];
        long sent = 0L;
        while (sent < size) {
            int n = file.read(buffer);
            if (n <= 0) continue;
            out.write(buffer, 0, n);
            sent += (long)n;
        }
        out.flush();
        return in.readInt() == -2;
    }

    private static boolean sendProcesses(ClientInfo client, String[] processes) throws IOException {
        return true;
    }

    private static void printHelp() {
        System.err.println("Usage: RunSession [-s | --session <session file>] [-t | --teams <teams directory>] [-c | --clients <clients file>] [-h | --help]");
        System.err.println("-s\t--session\tLoad the session from <session file>. Default \"session.xml\"");
        System.err.println("-t\t--teams\tLoad the teams from <teams directory>. Each subdirectory in <teams directory> should contain a file called \"commandlines.txt\" that contains all command lines used to launch the agents, as well as the binaries for those agents and any supporting files. Default \"teams\"");
        System.err.println("-c\t--clients\tGet the list of clients from <clients file>. Default \"clients.txt\"");
        System.err.println("-h\t--help\tPrint this help message");
    }

    private static ClientInfo[] loadClients(String clientFile) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(clientFile));
        String line = null;
        ArrayList<ClientInfo> result = new ArrayList<ClientInfo>();
        boolean isSim = true;
        do {
            if ((line = in.readLine()) == null || (line = line.trim()).startsWith("#") || line.equals("")) continue;
            if (line.equalsIgnoreCase("[simulation]")) {
                isSim = true;
                continue;
            }
            if (line.equalsIgnoreCase("[agents]")) {
                isSim = false;
                continue;
            }
            int index = line.indexOf(":");
            String addressString = null;
            int port = 12536;
            try {
                if (index == -1) {
                    addressString = line;
                } else {
                    addressString = line.substring(0, index);
                    port = Integer.parseInt(line.substring(index + 1));
                }
                InetAddress address = InetAddress.getByName(addressString);
                result.add(new ClientInfo(isSim, address, port));
            }
            catch (UnknownHostException e) {
                System.err.println("Cannot find address \"" + addressString + "\"");
            }
            catch (NumberFormatException e) {
                System.err.println("Bad port number in " + line);
            }
        } while (line != null);
        return result.toArray(new ClientInfo[result.size()]);
    }

    private static TeamInfo[] loadTeams(String teamsDirName) throws IOException {
        File teamsDir = new File(teamsDirName);
        if (!teamsDir.isDirectory()) {
            System.err.println("Error loading teams: " + teamsDirName + " is not a directory");
            return null;
        }
        ArrayList<TeamInfo> result = new ArrayList<TeamInfo>();
        File[] subdirs = teamsDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        for (int i = 0; i < subdirs.length; ++i) {
            File commandsFile = new File(subdirs[i].getAbsolutePath() + File.separator + "commandlines.txt");
            if (!commandsFile.exists()) {
                System.err.println("WARNING: Directory " + subdirs[i].getAbsolutePath() + " does not contain \"commandlines.txt\"");
                continue;
            }
            File[] allFiles = subdirs[i].listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return !f.getName().equals("commandlines.txt");
                }
            });
            ArrayList<String> allCommands = new ArrayList<String>();
            BufferedReader in = new BufferedReader(new FileReader(commandsFile));
            String line = null;
            do {
                if ((line = in.readLine()) == null || (line = line.trim()).startsWith("#")) continue;
                allCommands.add(line);
            } while (line != null);
            in.close();
            String[] commands = allCommands.toArray(new String[allCommands.size()]);
            String[] files = new String[allFiles.length];
            for (int j = 0; j < files.length; ++j) {
                files[j] = allFiles[j].getAbsolutePath();
            }
            result.add(new TeamInfo(commands, files));
        }
        return result.toArray(new TeamInfo[result.size()]);
    }

    private static class TeamInfo {
        String[] commands;
        String[] files;

        public TeamInfo(String[] c, String[] f) {
            this.commands = c;
            this.files = f;
        }
    }

    private static class ClientInfo {
        boolean isSimulation;
        InetAddress address;
        int port;

        public ClientInfo(boolean sim, InetAddress a, int p) {
            this.isSimulation = sim;
            this.address = a;
            this.port = p;
        }

        public String toString() {
            return this.address.getHostName() + ":" + this.port + " " + (this.isSimulation ? "running simulation" : "running agents");
        }
    }
}

