/*
 * Decompiled with CFR 0.152.
 */
package firesimulator.util;

import firesimulator.util.Geometry;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;

public class GeoTest
extends JFrame
implements MouseListener {
    private static final long serialVersionUID = 1L;
    float[] p = new float[]{50.0f, 50.0f, 300.0f, 300.0f, 100.0f, 100.0f, 200.0f, 200.0f};
    float[] cross;
    int current = 0;
    Point c;
    Point d;

    public static void main(String[] args) {
        GeoTest gt = new GeoTest();
        gt.setDefaultCloseOperation(3);
        gt.setVisible(true);
    }

    public GeoTest() {
        super("geotest");
        this.addMouseListener(this);
        this.setSize(500, 500);
        this.cross = null;
    }

    @Override
    public void update(Graphics g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.RED);
        g.drawLine((int)this.p[0], (int)this.p[1], (int)this.p[2], (int)this.p[3]);
        g.setColor(Color.GREEN);
        g.drawLine((int)this.p[4], (int)this.p[5], (int)this.p[6], (int)this.p[7]);
        if (this.d != null && this.c != null) {
            g.setColor(Color.YELLOW);
            g.drawLine(this.c.x, this.c.y, this.d.x, this.d.y);
        }
        if (this.cross != null) {
            g.setColor(Color.CYAN);
            g.drawLine((int)this.cross[0] - 10, (int)this.cross[1] - 10, (int)this.cross[0] + 10, (int)this.cross[1] + 10);
            g.drawLine((int)this.cross[0] - 10, (int)this.cross[1] + 10, (int)this.cross[0] + 10, (int)this.cross[1] - 10);
        }
        if (this.c != null) {
            g.setColor(Color.YELLOW);
            g.drawOval(this.c.x - 5, this.c.y - 5, 10, 10);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            if (this.current > 7) {
                this.current = 0;
            }
            this.p[this.current] = e.getX();
            this.p[++this.current] = e.getY();
            if (e.isControlDown()) {
                this.p[this.current - 1] = 200.0f;
            }
            if (e.isShiftDown()) {
                this.p[this.current - 1] = 400.0f;
            }
            ++this.current;
        }
        this.findPoint();
        this.d = Geometry.getRndPoint(this.c, 100.0);
        this.findIntersect();
        this.update(this.getGraphics());
    }

    private void findPoint() {
        Point a = new Point((int)this.p[0], (int)this.p[1]);
        Point b = new Point((int)this.p[2], (int)this.p[3]);
        this.c = Geometry.getRndPoint(a, b);
    }

    private void findIntersect() {
        this.cross = Geometry.intersect(this.p);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

