/*
 * Decompiled with CFR 0.152.
 */
package firesimulator.world;

import firesimulator.world.Edge;
import firesimulator.world.StreetNode;
import firesimulator.world.World;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Road
extends Edge {
    private static final Log LOG = LogFactory.getLog(Road.class);
    int width;
    int block;
    int linesToHead;
    int linesToTail;
    StreetNode head = null;
    StreetNode tail = null;

    public Road(int id) {
        super(id);
    }

    public void initialize(World world) {
        this.head = (StreetNode)world.getObject(this.getHeadID());
        this.tail = (StreetNode)world.getObject(this.getTailID());
        if (this.head == null || this.tail == null) {
            LOG.fatal((Object)"Error: head or tail of an streetnode did not exist. exiting");
            System.exit(1);
        }
    }

    public void setHead(StreetNode node) {
        this.head = node;
    }

    public void setTail(StreetNode node) {
        this.tail = node;
    }

    public StreetNode getHead() {
        return this.head;
    }

    public StreetNode getTail() {
        return this.tail;
    }

    @Override
    public String getType() {
        return "ROAD";
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setBlock(int block) {
        this.block = block;
    }

    public void setLinesToHead(int lines) {
        this.linesToHead = lines;
    }

    public void setLinesToTail(int lines) {
        this.linesToTail = lines;
    }
}

