/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.config;

import rescuecore2.config.AbstractValueConstraint;
import rescuecore2.config.Config;

public class FloatValueConstraint
extends AbstractValueConstraint {
    private double min;
    private double max;

    public FloatValueConstraint(String key) {
        this(key, Double.NaN, Double.NaN);
    }

    public FloatValueConstraint(String key, double min, double max) {
        super(key);
        this.min = min;
        this.max = max;
    }

    @Override
    public String getDescription() {
        boolean maxSpecified;
        boolean minSpecified = !Double.isNaN(this.min) && !Double.isInfinite(this.min);
        boolean bl = maxSpecified = !Double.isNaN(this.max) && !Double.isInfinite(this.max);
        if (!minSpecified && !maxSpecified) {
            return "Must be a number";
        }
        if (!minSpecified) {
            return "Must be a number less than or equal to " + this.max;
        }
        if (!maxSpecified) {
            return "Must be a number greater than or equal to " + this.min;
        }
        return "Must be a number between " + this.min + " and " + this.max + " inclusive";
    }

    @Override
    public boolean isValid(String value, Config config) {
        try {
            double d = Double.parseDouble(value);
            boolean minSpecified = !Double.isNaN(this.min) && !Double.isInfinite(this.min);
            boolean maxSpecified = !Double.isNaN(this.max) && !Double.isInfinite(this.max);
            return !(minSpecified && d < this.min || maxSpecified && d > this.max);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

