/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.connection;

import java.io.IOException;
import java.net.Socket;
import rescuecore2.connection.StreamConnection;
import rescuecore2.log.Logger;

public class TCPConnection
extends StreamConnection {
    private Socket socket;

    public TCPConnection(int port) throws IOException {
        this(null, port);
    }

    public TCPConnection(String address, int port) throws IOException {
        this(new Socket(address, port));
    }

    public TCPConnection(Socket socket) throws IOException {
        super(socket.getInputStream(), socket.getOutputStream());
        this.socket = socket;
        socket.setSoTimeout(1000);
        this.setName("TCPConnection: local port " + socket.getLocalPort() + ", endpoint = " + socket.getInetAddress() + ":" + socket.getPort());
    }

    @Override
    protected void shutdownImpl() {
        super.shutdownImpl();
        try {
            this.socket.close();
        }
        catch (IOException e) {
            Logger.error("Error closing TCP connection", e);
        }
    }
}

