/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.log;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import rescuecore2.config.Config;
import rescuecore2.log.LogRecord;
import rescuecore2.log.RecordType;
import rescuecore2.misc.EncodingTools;

public class ConfigRecord
implements LogRecord {
    private Config config;

    public ConfigRecord(Config config) {
        this.config = config;
    }

    public ConfigRecord(InputStream in) throws IOException {
        this.read(in);
    }

    @Override
    public RecordType getRecordType() {
        return RecordType.CONFIG;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        Set<String> all = this.config.getAllKeys();
        EncodingTools.writeInt32(all.size(), out);
        for (String key : all) {
            String value = this.config.getValue(key);
            EncodingTools.writeString(key, out);
            EncodingTools.writeString(value, out);
        }
    }

    @Override
    public void read(InputStream in) throws IOException {
        this.config = new Config();
        int size = EncodingTools.readInt32(in);
        for (int i = 0; i < size; ++i) {
            String key = EncodingTools.readString(in);
            String value = EncodingTools.readString(in);
            this.config.setValue(key, value);
        }
    }

    public Config getConfig() {
        return this.config;
    }
}

