/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.messages;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rescuecore2.messages.Message;
import rescuecore2.messages.MessageComponent;

public abstract class AbstractMessage
implements Message {
    private String urn;
    private List<MessageComponent> components;

    protected AbstractMessage(String urn) {
        this.urn = urn;
        this.components = new ArrayList<MessageComponent>();
    }

    protected AbstractMessage(Enum<?> urn) {
        this(urn.toString());
    }

    @Override
    public final String getURN() {
        return this.urn;
    }

    public final List<MessageComponent> getComponents() {
        return this.components;
    }

    protected void addMessageComponent(MessageComponent component) {
        this.components.add(component);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.urn);
        result.append(" : ");
        Iterator<MessageComponent> it = this.components.iterator();
        while (it.hasNext()) {
            MessageComponent next = it.next();
            result.append(next.toString());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    @Override
    public void write(OutputStream out) throws IOException {
        for (MessageComponent next : this.components) {
            next.write(out);
        }
    }

    @Override
    public void read(InputStream in) throws IOException {
        for (MessageComponent next : this.components) {
            next.read(in);
        }
    }
}

