/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.messages.components;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import rescuecore2.messages.AbstractMessageComponent;
import rescuecore2.misc.EncodingTools;
import rescuecore2.worldmodel.Entity;

public class EntityListComponent
extends AbstractMessageComponent {
    private List<Entity> entities;

    public EntityListComponent(String name) {
        super(name);
        this.entities = new ArrayList<Entity>();
    }

    public EntityListComponent(String name, Collection<? extends Entity> entities) {
        super(name);
        this.entities = new ArrayList<Entity>(entities);
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(Collection<? extends Entity> entities) {
        this.entities = new ArrayList<Entity>(entities);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        EncodingTools.writeInt32(this.entities.size(), out);
        for (Entity next : this.entities) {
            EncodingTools.writeEntity(next, out);
        }
    }

    @Override
    public void read(InputStream in) throws IOException {
        this.entities.clear();
        int size = EncodingTools.readInt32(in);
        for (int i = 0; i < size; ++i) {
            Entity e = EncodingTools.readEntity(in);
            if (e == null) continue;
            this.entities.add(e);
        }
    }

    public String toString() {
        return this.getName() + " = " + this.entities.size() + " entities";
    }
}

