/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.messages.control;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import rescuecore2.config.Config;
import rescuecore2.messages.AbstractMessage;
import rescuecore2.messages.Control;
import rescuecore2.messages.components.ConfigComponent;
import rescuecore2.messages.components.EntityIDComponent;
import rescuecore2.messages.components.EntityListComponent;
import rescuecore2.messages.components.IntComponent;
import rescuecore2.messages.control.ControlMessageURN;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;

public class KAConnectOK
extends AbstractMessage
implements Control {
    private IntComponent requestID = new IntComponent("Request ID");
    private EntityIDComponent agentID = new EntityIDComponent("Agent ID");
    private EntityListComponent world = new EntityListComponent("Entities");
    private ConfigComponent config = new ConfigComponent("Agent config");

    public KAConnectOK(InputStream in) throws IOException {
        this();
        this.read(in);
    }

    public KAConnectOK(int requestID, EntityID agentID, Collection<? extends Entity> allEntities, Config config) {
        this();
        this.requestID.setValue(requestID);
        this.agentID.setValue(agentID);
        this.world.setEntities(allEntities);
        this.config.setConfig(config);
    }

    private KAConnectOK() {
        super(ControlMessageURN.KA_CONNECT_OK);
        this.addMessageComponent(this.requestID);
        this.addMessageComponent(this.agentID);
        this.addMessageComponent(this.world);
        this.addMessageComponent(this.config);
    }

    public int getRequestID() {
        return this.requestID.getValue();
    }

    public EntityID getAgentID() {
        return this.agentID.getValue();
    }

    public Collection<Entity> getEntities() {
        return this.world.getEntities();
    }

    public Config getConfig() {
        return this.config.getConfig();
    }
}

