/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.java;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import rescuecore2.log.Logger;

public final class JavaTools {
    private JavaTools() {
    }

    public static <T> T instantiate(String className, Class<T> outputClass) {
        try {
            Class<T> clazz = Class.forName(className).asSubclass(outputClass);
            if (Modifier.isAbstract(clazz.getModifiers())) {
                return null;
            }
            return clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            Logger.info("Could not find class " + className);
        }
        catch (IllegalAccessException e) {
            Logger.info("Could not instantiate class " + className);
        }
        catch (InstantiationException e) {
            Logger.info("Could not instantiate class " + className);
        }
        return null;
    }

    public static <T> T instantiateFactory(String classname, Class<T> outputClass) {
        Class<T> clazz;
        block12: {
            try {
                clazz = Class.forName(classname).asSubclass(outputClass);
            }
            catch (ClassNotFoundException e) {
                Logger.info("Could not find class " + classname);
                return null;
            }
            catch (ClassCastException e) {
                Logger.info(classname + " is not a subclass of " + outputClass.getName(), e);
                return null;
            }
            try {
                Field field = clazz.getField("INSTANCE");
                if (!Modifier.isStatic(field.getModifiers())) break block12;
                try {
                    Object o = field.get(null);
                    if (o != null) {
                        return outputClass.cast(o);
                    }
                }
                catch (IllegalAccessException e) {
                    Logger.info("Could not access INSTANCE field in class " + classname + ": trying constructor.");
                }
                catch (ClassCastException e) {
                    Logger.info("Could not cast INSTANCE field to " + outputClass + " in class " + classname + ": trying constructor.");
                }
            }
            catch (NoSuchFieldException e) {
                Logger.info("No INSTANCE field in class " + classname);
            }
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            Logger.info("Could not instantiate class " + classname);
        }
        catch (InstantiationException e) {
            Logger.info("Could not instantiate class " + classname);
        }
        return null;
    }
}

