/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.java;

import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rescuecore2.components.Agent;
import rescuecore2.components.Component;
import rescuecore2.components.Simulator;
import rescuecore2.components.Viewer;
import rescuecore2.log.Logger;
import rescuecore2.registry.EntityFactory;
import rescuecore2.registry.MessageFactory;
import rescuecore2.registry.PropertyFactory;

public class LoadableType {
    public static final LoadableType MESSAGE_FACTORY = new LoadableType("MessageFactory", "(.+MessageFactory).class", MessageFactory.class);
    public static final LoadableType ENTITY_FACTORY = new LoadableType("EntityFactory", "(.+EntityFactory).class", EntityFactory.class);
    public static final LoadableType PROPERTY_FACTORY = new LoadableType("PropertyFactory", "(.+PropertyFactory).class", PropertyFactory.class);
    public static final LoadableType AGENT = new LoadableType("Agent", "(.+(?:FireBrigade|PoliceForce|AmbulanceTeam|Centre|Center|Civilian)).class", Agent.class);
    public static final LoadableType SIMULATOR = new LoadableType("Simulator", "(.+Simulator).class", Simulator.class);
    public static final LoadableType VIEWER = new LoadableType("Viewer", "(.+Viewer).class", Viewer.class);
    public static final LoadableType COMPONENT = new LoadableType("Component", null, Component.class);
    private String manifestKey;
    private Pattern regex;
    private Class<?> clazz;

    public LoadableType(String manifestKey, String regex, Class<?> clazz) {
        this.manifestKey = manifestKey;
        this.regex = regex == null ? null : Pattern.compile(regex);
        this.clazz = clazz;
    }

    public List<String> processManifest(Manifest mf) {
        Attributes att = mf.getMainAttributes();
        String value = att.getValue(this.manifestKey);
        ArrayList<String> result = new ArrayList<String>();
        if (value != null) {
            for (String next : value.split(" ")) {
                try {
                    Class<?> testClass = Class.forName(next);
                    if (!this.clazz.isAssignableFrom(testClass)) {
                        Logger.warn("Manifest entry '" + this.manifestKey + "' contains invalid class name: '" + next + "' is not a subclass of '" + this.clazz.getName() + "'");
                        continue;
                    }
                    if (testClass.isInterface()) {
                        Logger.warn("Manifest entry '" + this.manifestKey + "' contains invalid class name: '" + next + "' is an interface");
                        continue;
                    }
                    result.add(next);
                }
                catch (ClassNotFoundException e) {
                    Logger.warn("Manifest entry '" + this.manifestKey + "' contains invalid class name: '" + next + "' not found");
                }
            }
        }
        return result;
    }

    public String processJarEntry(JarEntry e) {
        if (this.regex == null) {
            return null;
        }
        Matcher m = this.regex.matcher(e.getName());
        if (m.matches()) {
            String className = null;
            try {
                className = m.group(1).replace("/", ".");
                Class<?> testClass = Class.forName(className);
                if (this.clazz.isAssignableFrom(testClass) && !testClass.isInterface()) {
                    return className;
                }
            }
            catch (ClassNotFoundException ex) {
                Logger.warn("Class " + className + " not found");
            }
        }
        return null;
    }
}

