/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.registry;

import java.util.Set;
import rescuecore2.registry.EntityFactory;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;

public class FilterEntityFactory
implements EntityFactory {
    private EntityFactory downstream;
    private Set<String> urns;
    private boolean inclusive;

    public FilterEntityFactory(EntityFactory downstream, Set<String> urns, boolean inclusive) {
        this.downstream = downstream;
        this.urns = urns;
        this.inclusive = inclusive;
    }

    @Override
    public String[] getKnownEntityURNs() {
        return this.downstream.getKnownEntityURNs();
    }

    @Override
    public Entity makeEntity(String urn, EntityID id) {
        if (this.inclusive && !this.urns.contains(urn)) {
            return null;
        }
        if (!this.inclusive && this.urns.contains(urn)) {
            return null;
        }
        return this.downstream.makeEntity(urn, id);
    }
}

